/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import de.sekmi.histream.export.ExportWriter;
import de.sekmi.histream.export.TableWriter;
import java.io.IOException;
import java.util.function.Supplier;

public class ExceptionCausingWriter
implements ExportWriter {
    private Supplier<IOException> exceptions = () -> new IOException("Expected IO exception");
    private WhenToThrow when;
    private WhereToThrow where;

    public ExceptionCausingWriter(WhereToThrow where, WhenToThrow when) {
        this.where = where;
        this.when = when;
    }

    private void throwIf(WhereToThrow whereToThrow, WhenToThrow whenToThrow) throws IOException {
        if (this.where == whereToThrow && this.when == whenToThrow) {
            throw this.exceptions.get();
        }
    }

    public TableWriter openPatientTable() throws IOException {
        this.throwIf(WhereToThrow.PatientTable, WhenToThrow.OpenTable);
        return new ExceptionThrowingTable(WhereToThrow.PatientTable);
    }

    public TableWriter openVisitTable() throws IOException {
        this.throwIf(WhereToThrow.VisitTable, WhenToThrow.OpenTable);
        return new ExceptionThrowingTable(WhereToThrow.VisitTable);
    }

    public TableWriter openEAVTable(String id) throws IOException {
        this.throwIf(WhereToThrow.EAVTable, WhenToThrow.OpenTable);
        return new ExceptionThrowingTable(WhereToThrow.EAVTable);
    }

    public void close() throws IOException {
        if (this.where == WhereToThrow.CloseWriter) {
            throw this.exceptions.get();
        }
    }

    private class ExceptionThrowingTable
    implements TableWriter {
        private WhereToThrow table;

        public ExceptionThrowingTable(WhereToThrow table) {
            this.table = table;
        }

        public void header(String[] headers) throws IOException {
            ExceptionCausingWriter.this.throwIf(this.table, WhenToThrow.WriteHeader);
        }

        public void row(String[] columns) throws IOException {
            ExceptionCausingWriter.this.throwIf(this.table, WhenToThrow.WriteRow);
        }

        public void close() throws IOException {
            ExceptionCausingWriter.this.throwIf(this.table, WhenToThrow.CloseTable);
        }
    }

    protected static enum WhereToThrow {
        PatientTable,
        VisitTable,
        EAVTable,
        CloseWriter;

    }

    protected static enum WhenToThrow {
        OpenTable,
        WriteHeader,
        WriteRow,
        CloseTable;

    }
}

