/**
 * <h1>projen-test</h1>
 * <p>
 * This is a test project to test the workflow of creating a CDK construct library using <a href="https://github.com/projen/projen">projen</a>.
 * You can follow the steps I've executed below.
 * <p>
 * The CDK construct <code>InlineLambdaConstruct</code> only creates a very simple Lambda function that prints out the event it's receiving.
 * Did you know there are multiple <a href="https://www.sebastianhesse.de/2021/01/16/5-ways-to-bundle-a-lambda-function-within-an-aws-cdk-construct/">ways to bundle an AWS Lambda function in a CDK construct</a> ?
 * <p>
 * <h2>Questions?</h2>
 * <p>
 * Do you have questions?
 * Feel free to reach out via <a href="https://twitter.com/seeebiii">Twitter</a> or visit my website - I'm a <a href="https://www.sebastianhesse.de">Freelance Software Engineer</a> focusing on Serverless Cloud Projects.
 * <p>
 * <h2>Steps For Creating a New CDK Construct Using projen</h2>
 * <p>
 * In case you want to test <code>projen</code> as well, here are the steps I've performed.
 * <p>
 * <h3>Setup Project</h3>
 * <p>
 * <ol>
 * <li>Initialize a new project:
 * <p>
 * <blockquote><pre>
 * mkdir projen-test
 * cd projen-test
 * npx projen new awscdk-construct
 * </pre></blockquote></li>
 * <li>Now create a new Git repository using <code>git init</code> and connect an existing Git project using <code>git remote add origin  &lt;REMOTE_URL&gt;</code>.
 * (Create your Git repository in GitHub first before you call <code>git remote add ...</code>)
 * <p>
 * <ul>
 * <li>Note: if your local branch is <code>master</code> but your remote branch is <code>main</code>, then use <code>git branch -M main</code> to rename the local branch.</li>
 * </ul></li>
 * <li>Create alias for my command-line: <code>alias pj='npx projen'</code></li>
 * <li>Adjust the <code>projen</code> options in <code>.projenrc.js</code> a bit. For example:
 * <p>
 * <ul>
 * <li>adjust metadata like <code>name</code>, <code>author</code>, <code>authorName</code>, <code>authorAddress</code>, <code>repositoryUrl</code></li>
 * <li>add <code>cdkAssert: true</code> for being able to test my CDK construct</li>
 * <li>add <code>cdkDependencies: ['&#64;aws-cdk/core', '&#64;aws-cdk/aws-lambda']</code> to let projen add these CDK dependencies for me</li>
 * <li>add <code>docgen: true</code> so it automatically generates API documentation 🙌</li>
 * <li>add <code>eslint: true</code> to make sure I use common coding standards</li>
 * <li>add <code>dependabot: true</code> and <code>dependabotOptions: {...}</code> to enable <a href="https://dependabot.com/">Dependabot</a> because I hate managing dependency updates manually</li>
 * <li>add <code>gitignore: ['.idea']</code> because I love using IntelliJ ♥️ but I don't want to commit its settings</li>
 * <li>add <code>mergify: false</code> because I haven't used it so far</li>
 * <li>add automatic releases using <a href="https://github.com/features/actions">GitHub Actions</a>
 * <p>
 * <ul>
 * <li><code>releaseBranches: ['main']</code></li>
 * <li><code>releaseEveryCommit: true</code></li>
 * <li><code>releaseToNpm: true</code> -&gt; Yes, I want to release a new version to NPM every time :)</li>
 * <li><code>releaseWorkflow: true</code></li>
 * </ul></li>
 * <li>add <code>projectType: ProjectType.LIB</code> since this one is a library</li>
 * <li>use <code>packageManager: NodePackageManager.NPM</code> if you want to use NPM instead of Yarn - might be important in case you are migrating an existing CDK Construct to projen.</li>
 * </ul>
 * <p>
 * Don't forget to add necessary imports when applying the <code>projen</code> settings, e.g. for <code>ProjectType</code>.</li>
 * <li>Run <code>pj</code> again on your command-line.
 * This will update all project files like <a href="package.json">package.json</a> and similar based on what you have configured in <a href=".projenrc.js">.projenrc.js</a>.</li>
 * </ol>
 * <p>
 * <h3>Write CDK Construct</h3>
 * <p>
 * <ol>
 * <li>Write a simple CDK construct in <a href="src/index.ts">src/index.ts</a>.</li>
 * <li>Write a simple test for this construct in <a href="test/index.test.ts">test/index.test.ts</a>.</li>
 * <li>Run <code>yarn run build</code>.
 * This command will execute the tests using <a href="https://jestjs.io/">Jest</a> and also generate <a href="API.md">API.md</a> 😍</li>
 * </ol>
 * <p>
 * <h3>Connect To GitHub</h3>
 * <p>
 * If you have followed all previous steps, you'll probably have noticed that there are a few files in <a href=".github/workflows">.github/workflows</a> folder.
 * They take care of running GitHub Actions to build and release/publish the library to NPM and other repositories.
 * <p>
 * <ol>
 * <li>Add all files to Git and commit your changes.</li>
 * </ol>
 * <p>
 * <blockquote><pre>
 * # Maybe adjust this to really add all files from every folder, or use IntelliJ or some Git GUI to do this
 * git add .
 * git commit -M "Initial commit"
 * </pre></blockquote>
 * <p>
 * <h3>Publish to NPM</h3>
 * <p>
 * <ol>
 * <li>Create an <a href="https://docs.npmjs.com/about-access-tokens">access token</a> for NPM.
 * Use type 'Automation' for the token type.
 * The token will be used in a GitHub Action to release your package.</li>
 * <li>Add the access token as a <a href="https://docs.github.com/en/actions/reference/encrypted-secrets">repository secret</a> to your GitHub repository.
 * Use <code>NPM_TOKEN</code> as name and insert the access token from the previous step.
 * This is</li>
 * <li>Push <code>git push -u origin main</code>.
 * If you have configured <code>releaseBranches: ['main']</code> in <a href=".projenrc.js">.projenrc.js</a> as discussed above, then a new Action run is triggered that builds your CDK construct and publishes it to NPM.</li>
 * </ol>
 * <p>
 * <h3>Publish to Maven Repository</h3>
 * <p>
 * TODO
 * <p>
 * <h3>Publish to PyPi</h3>
 * <p>
 * TODO
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package de.sebastianhesse.examples.projen.test;
