package de.sebastianhesse.cdk.ses.verify.constructs;

/**
 * A construct to verify a SES domain identity.
 * <p>
 * It initiates a domain verification and can automatically create
 * appropriate records in Route53 to verify the domain. Also, it's possible to attach a notification topic for bounces,
 * complaints or delivery notifications.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * new VerifySesDomain(this, 'SesDomainVerification', {
 *   domainName: 'example.org'
 * });
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-10-20T08:02:17.161Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = de.sebastianhesse.cdk.ses.verify.constructs.$Module.class, fqn = "@seeebiii/ses-verify-identities.VerifySesDomain")
public class VerifySesDomain extends software.constructs.Construct {

    protected VerifySesDomain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VerifySesDomain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param parent This parameter is required.
     * @param name This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VerifySesDomain(final @org.jetbrains.annotations.NotNull software.constructs.Construct parent, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull de.sebastianhesse.cdk.ses.verify.constructs.IVerifySesDomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parent, "parent is required"), java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The SNS topic where bounces, complaints or delivery notifications can be sent to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic getNotificationTopic() {
        return software.amazon.jsii.Kernel.get(this, "notificationTopic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
    }

    /**
     * A fluent builder for {@link de.sebastianhesse.cdk.ses.verify.constructs.VerifySesDomain}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<de.sebastianhesse.cdk.ses.verify.constructs.VerifySesDomain> {
        /**
         * @return a new instance of {@link Builder}.
         * @param parent This parameter is required.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct parent, final java.lang.String name) {
            return new Builder(parent, name);
        }

        private final software.constructs.Construct parent;
        private final java.lang.String name;
        private final de.sebastianhesse.cdk.ses.verify.constructs.IVerifySesDomainProps.Builder props;

        private Builder(final software.constructs.Construct parent, final java.lang.String name) {
            this.parent = parent;
            this.name = name;
            this.props = new de.sebastianhesse.cdk.ses.verify.constructs.IVerifySesDomainProps.Builder();
        }

        /**
         * A domain name to be used for the SES domain identity, e.g. 'sub-domain.example.org'.
         * <p>
         * @return {@code this}
         * @param domainName A domain name to be used for the SES domain identity, e.g. 'sub-domain.example.org'. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * Whether to automatically add DKIM records to the hosted zone of your domain.
         * <p>
         * This only works if your domain is
         * managed by Route53. Otherwise disable it.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param addDkimRecords Whether to automatically add DKIM records to the hosted zone of your domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addDkimRecords(final java.lang.Boolean addDkimRecords) {
            this.props.addDkimRecords(addDkimRecords);
            return this;
        }

        /**
         * Whether to automatically add a MX record to the hosted zone of your domain.
         * <p>
         * This only works if your domain is
         * managed by Route53. Otherwise disable it.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param addMxRecord Whether to automatically add a MX record to the hosted zone of your domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addMxRecord(final java.lang.Boolean addMxRecord) {
            this.props.addMxRecord(addMxRecord);
            return this;
        }

        /**
         * Whether to automatically add a TXT record to the hosed zone of your domain.
         * <p>
         * This only works if your domain is
         * managed by Route53. Otherwise disable it.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param addTxtRecord Whether to automatically add a TXT record to the hosed zone of your domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addTxtRecord(final java.lang.Boolean addTxtRecord) {
            this.props.addTxtRecord(addTxtRecord);
            return this;
        }

        /**
         * Optional: A hosted zone id to be used for retrieving the Route53 hosted zone for adding new records.
         * <p>
         * Providing an
         * id will skip the hosted zone lookup.
         * <p>
         * @return {@code this}
         * @param hostedZoneId Optional: A hosted zone id to be used for retrieving the Route53 hosted zone for adding new records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneId(final java.lang.String hostedZoneId) {
            this.props.hostedZoneId(hostedZoneId);
            return this;
        }

        /**
         * A hosted zone name to be used for retrieving the Route53 hosted zone for adding new record, e.g. 'example.org'. If you also provide hostedZoneId, it is assumed that these values are correct and no lookup happens.
         * <p>
         * Default: same as domainName
         * <p>
         * @return {@code this}
         * @param hostedZoneName A hosted zone name to be used for retrieving the Route53 hosted zone for adding new record, e.g. 'example.org'. If you also provide hostedZoneId, it is assumed that these values are correct and no lookup happens. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneName(final java.lang.String hostedZoneName) {
            this.props.hostedZoneName(hostedZoneName);
            return this;
        }

        /**
         * An SNS topic where bounces, complaints or delivery notifications can be sent to.
         * <p>
         * If none is provided, a new topic
         * will be created and used for all different notification types.
         * <p>
         * Default: new topic will be created
         * <p>
         * @return {@code this}
         * @param notificationTopic An SNS topic where bounces, complaints or delivery notifications can be sent to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTopic(final software.amazon.awscdk.services.sns.ITopic notificationTopic) {
            this.props.notificationTopic(notificationTopic);
            return this;
        }

        /**
         * Select for which notification types you want to configure a topic.
         * <p>
         * Default: [Bounce, Complaint]
         * <p>
         * @return {@code this}
         * @param notificationTypes Select for which notification types you want to configure a topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTypes(final java.util.List<java.lang.String> notificationTypes) {
            this.props.notificationTypes(notificationTypes);
            return this;
        }

        /**
         * Whether to DESTROY or RETAIN the domain on removal.
         * <p>
         * Default: DESTROY
         * <p>
         * @return {@code this}
         * @param removalPolicy Whether to DESTROY or RETAIN the domain on removal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link de.sebastianhesse.cdk.ses.verify.constructs.VerifySesDomain}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public de.sebastianhesse.cdk.ses.verify.constructs.VerifySesDomain build() {
            return new de.sebastianhesse.cdk.ses.verify.constructs.VerifySesDomain(
                this.parent,
                this.name,
                this.props.build()
            );
        }
    }
}
