/*
 * Decompiled with CFR 0.152.
 */
package de.scrum_master.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateableTreeSet<E extends Updateable>
extends TreeSet<E> {
    private static final long serialVersionUID = 1170156554123865966L;
    private Map<E, Object> toBeUpdated = new IdentityHashMap<E, Object>();
    private Map<E, Object> toBeRemoved = new IdentityHashMap<E, Object>();

    public UpdateableTreeSet() {
    }

    public UpdateableTreeSet(Collection<? extends E> c) {
        super(c);
    }

    public UpdateableTreeSet(Comparator<? super E> comparator) {
        super(comparator);
    }

    public UpdateableTreeSet(SortedSet<E> s) {
        super(s);
    }

    public void markForUpdate(E element, Object newValue) {
        this.toBeUpdated.put(element, newValue);
    }

    public void markForUpdate(E element) {
        this.toBeUpdated.put(element, null);
    }

    public void markForRemoval(E element) {
        this.toBeRemoved.put(element, null);
    }

    public synchronized void updateMarked() {
        this.removeAll(this.toBeRemoved.keySet());
        this.toBeRemoved.clear();
        this.removeAll(this.toBeUpdated.keySet());
        for (Updateable element : this.toBeUpdated.keySet()) {
            element.update(this.toBeUpdated.get(element));
        }
        this.addAll(this.toBeUpdated.keySet());
        this.toBeUpdated.clear();
    }

    public synchronized void updateAll() {
        this.toBeRemoved.clear();
        this.toBeUpdated.clear();
        for (Updateable element : this) {
            this.markForUpdate(element);
        }
        this.updateMarked();
    }

    public synchronized boolean update(E element, Object newValue) {
        if (this.remove(element)) {
            element.update(newValue);
            return this.add(element);
        }
        return false;
    }

    public boolean update(E element) {
        return this.update(element, null);
    }

    public static interface Updateable {
        public void update();

        public void update(Object var1);
    }
}

