/*
 * Decompiled with CFR 0.152.
 */
package de.scravy;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public final class PathUtil {
    private PathUtil() {
        throw new UnsupportedOperationException();
    }

    public static Path getCurrentWorkingDirectory() {
        String workingDirectory = System.getProperty("user.dir");
        if (workingDirectory == null || workingDirectory.isEmpty()) {
            return Paths.get(".", new String[0]);
        }
        return Paths.get(workingDirectory, new String[0]);
    }

    public static Optional<Path> findFile(String fileName) {
        return PathUtil.findFile(PathUtil.getCurrentWorkingDirectory(), fileName);
    }

    public static Optional<Path> findFile(Path directory, String fileName) {
        Path currentPath = directory;
        do {
            Path maybeTheFile;
            if (!Files.isRegularFile(maybeTheFile = currentPath.resolve(fileName), new LinkOption[0])) continue;
            return Optional.of(maybeTheFile);
        } while ((currentPath = currentPath.getParent()) != null);
        return Optional.empty();
    }
}

