/*
 * Decompiled with CFR 0.152.
 */
package de.scravy;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class ListView<T>
extends AbstractList<T>
implements List<T>,
Serializable {
    private final List<T> parent;
    private final int offset;

    public static void main(String ... args) {
        List<Integer> xs = Arrays.asList(1, 2, 3, 4, 5);
        ListView<Integer> ys = ListView.of(xs, 1);
        ListView<Integer> zs = ListView.of(ys, 1);
        System.out.println(xs.get(0));
        System.out.println(ys.get(0));
        System.out.println(zs.get(0));
        System.out.println(ListView.of(zs, 3).isEmpty());
        zs.forEach(System.out::println);
    }

    private ListView(List<T> parent, int offset) {
        this.parent = parent;
        this.offset = offset;
    }

    public static <T> ListView<T> of(T[] parent) {
        return ListView.of(Arrays.asList(parent));
    }

    public static <T> ListView<T> of(T[] parent, int offset) {
        return ListView.of(Arrays.asList(parent), offset);
    }

    public static <T> ListView<T> of(List<T> parent) {
        if (parent instanceof ListView) {
            return (ListView)parent;
        }
        return new ListView<T>(parent, 0);
    }

    public static <T> ListView<T> of(List<T> parent, int offset) {
        if (parent instanceof ListView) {
            ListView listView = (ListView)parent;
            return new ListView<T>(listView.parent, listView.offset + offset);
        }
        return new ListView<T>(parent, offset);
    }

    @Override
    public int size() {
        return this.parent.size() - this.offset;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return this.parent.listIterator(this.offset);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int ix = 0;
        for (T obj : this) {
            array[ix] = obj;
            ++ix;
        }
        return array;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        return this.parent.get(this.offset + index);
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.parent.listIterator(this.offset);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.parent.listIterator(this.offset + index);
    }

    @Override
    public String toString() {
        return this.stream().map(Object::toString).collect(Collectors.joining(", "));
    }
}

