/*
 * Decompiled with CFR 0.152.
 */
package de.scravy;

import de.scravy.Either;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class Exceptional<V>
implements Serializable {
    private Exceptional() {
    }

    public Exception getException() {
        throw new RuntimeException();
    }

    public V getValue() {
        throw new RuntimeException();
    }

    public boolean isException() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public abstract Exceptional<V> mapLeft(Function<Exception, Exception> var1);

    public abstract <W> Exceptional<W> map(Function<V, W> var1);

    public abstract <W> Exceptional<W> flatMap(Function<V, Exceptional<W>> var1);

    public abstract Exceptional<V> forEach(Consumer<V> var1);

    public abstract Exceptional<V> recover(Function<Exception, V> var1);

    public abstract <W> Exceptional<W> recoverWith(Function<Exception, Exceptional<W>> var1);

    public abstract Exceptional<V> filter(Predicate<V> var1, Exception var2);

    public Exceptional<V> filter(Predicate<V> f, String msg) {
        return this.filter(f, new Exception(msg));
    }

    public abstract Exceptional<V> filterWith(Predicate<V> var1, Supplier<Exception> var2);

    public abstract void consume(Consumer<Exception> var1, Consumer<V> var2);

    public abstract <T> T foldWith(Function<Exception, T> var1, Function<V, T> var2);

    public abstract Either<Exception, V> toEither();

    public abstract Optional<V> toOptional();

    public abstract V get() throws Exception;

    public static <V> Exceptional<V> from(Optional<V> optional, Exception exc) {
        return optional.map(Exceptional::value).orElse(Exceptional.exception(exc));
    }

    public static <V> Exceptional<V> exception(Exception exc) {
        return new Failure(exc);
    }

    public static <V> Exceptional<V> value(V value) {
        return new Success(value);
    }

    public static class Success<V>
    extends Exceptional<V> {
        private final V value;

        private Success(V value) {
            this.value = value;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public Exceptional<V> mapLeft(Function<Exception, Exception> f) {
            return this;
        }

        @Override
        public <W> Exceptional<W> map(Function<V, W> f) {
            return new Success<W>(f.apply(this.value));
        }

        @Override
        public <W> Exceptional<W> flatMap(Function<V, Exceptional<W>> f) {
            return f.apply(this.value);
        }

        @Override
        public Exceptional<V> forEach(Consumer<V> f) {
            f.accept(this.value);
            return this;
        }

        @Override
        public Success<V> recover(Function<Exception, V> f) {
            return this;
        }

        @Override
        public <W> Exceptional<W> recoverWith(Function<Exception, Exceptional<W>> f) {
            return this;
        }

        @Override
        public Exceptional<V> filter(Predicate<V> f, Exception v) {
            if (f.test(this.value)) {
                return this;
            }
            return new Failure(v);
        }

        @Override
        public Exceptional<V> filterWith(Predicate<V> f, Supplier<Exception> v) {
            if (f.test(this.value)) {
                return this;
            }
            return new Failure(v.get());
        }

        @Override
        public void consume(Consumer<Exception> f, Consumer<V> g) {
            g.accept(this.value);
        }

        @Override
        public <T> T foldWith(Function<Exception, T> f, Function<V, T> g) {
            return g.apply(this.value);
        }

        @Override
        public Either<Exception, V> toEither() {
            return Either.right(this.value);
        }

        @Override
        public Optional<V> toOptional() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public V get() {
            return this.value;
        }

        public String toString() {
            return String.format("Value(%s)", this.value);
        }
    }

    public static class Failure<V>
    extends Exceptional<V> {
        private final Exception exception;

        private Failure(Exception exception) {
            this.exception = exception;
        }

        @Override
        public Exception getException() {
            return this.exception;
        }

        @Override
        public boolean isException() {
            return true;
        }

        @Override
        public Exceptional<V> mapLeft(Function<Exception, Exception> f) {
            return new Failure<V>(f.apply(this.exception));
        }

        @Override
        public <W> Exceptional<W> map(Function<V, W> f) {
            return this;
        }

        @Override
        public <W> Exceptional<W> flatMap(Function<V, Exceptional<W>> f) {
            return this;
        }

        @Override
        public Exceptional<V> forEach(Consumer<V> f) {
            return this;
        }

        @Override
        public Exceptional<V> recover(Function<Exception, V> f) {
            return Failure.value(f.apply(this.exception));
        }

        @Override
        public <W> Exceptional<W> recoverWith(Function<Exception, Exceptional<W>> f) {
            return f.apply(this.exception);
        }

        @Override
        public Exceptional<V> filter(Predicate<V> f, Exception v) {
            return this;
        }

        @Override
        public Exceptional<V> filterWith(Predicate<V> f, Supplier<Exception> v) {
            return this;
        }

        @Override
        public void consume(Consumer<Exception> f, Consumer<V> g) {
            f.accept(this.exception);
        }

        @Override
        public <T> T foldWith(Function<Exception, T> f, Function<V, T> g) {
            return f.apply(this.exception);
        }

        @Override
        public Either<Exception, V> toEither() {
            return Either.left(this.exception);
        }

        @Override
        public Optional<V> toOptional() {
            return Optional.empty();
        }

        @Override
        public V get() throws Exception {
            throw this.exception;
        }

        public String toString() {
            return String.format("%s(%s)", this.exception.getClass().getSimpleName(), this.exception.getMessage());
        }
    }
}

