/*
 * Decompiled with CFR 0.152.
 */
package de.scravy;

import de.scravy.Exceptional;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class Either<L, R>
implements Serializable {
    private Either() {
        throw new UnsupportedOperationException();
    }

    public L left() {
        return null;
    }

    public R right() {
        return null;
    }

    public boolean isLeft() {
        return false;
    }

    public boolean isRight() {
        return false;
    }

    public abstract <M> Either<M, R> mapLeft(Function<L, M> var1);

    public abstract <S> Either<L, S> map(Function<R, S> var1);

    public abstract <S> Either<L, S> flatMap(Function<R, Either<L, S>> var1);

    public abstract Either<L, R> forEach(Consumer<R> var1);

    public abstract Right<L, R> recover(Function<L, R> var1);

    public abstract Either<L, R> recoverWith(Function<L, Either<L, R>> var1);

    public abstract Either<L, R> filter(Predicate<R> var1, L var2);

    public abstract Either<L, R> filterWith(Predicate<R> var1, Supplier<L> var2);

    public abstract void consume(Consumer<L> var1, Consumer<R> var2);

    public abstract <T> T foldWith(Function<L, T> var1, Function<R, T> var2);

    public abstract Optional<R> toOptional();

    public static <L, R> Left<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Right<L, R> right(R value) {
        return new Right(value);
    }

    public static <V> Exceptional<V> toExceptional(Either<Exception, V> either) {
        return either.foldWith(Exceptional::exception, Exceptional::value);
    }

    public static class Right<L, R>
    extends Either<L, R> {
        final R value;

        private Right(R value) {
            this.value = value;
        }

        @Override
        public R right() {
            return this.value;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public <M> Right<M, R> mapLeft(Function<L, M> f) {
            return this;
        }

        @Override
        public <S> Right<L, S> map(Function<R, S> f) {
            return new Right<L, S>(f.apply(this.value));
        }

        @Override
        public <S> Either<L, S> flatMap(Function<R, Either<L, S>> f) {
            return f.apply(this.value);
        }

        @Override
        public Right<L, R> forEach(Consumer<R> f) {
            f.accept(this.value);
            return this;
        }

        @Override
        public Right<L, R> recover(Function<L, R> f) {
            return this;
        }

        @Override
        public Either<L, R> recoverWith(Function<L, Either<L, R>> f) {
            return this;
        }

        @Override
        public Either<L, R> filter(Predicate<R> f, L v) {
            if (f.test(this.value)) {
                return this;
            }
            return new Left(v);
        }

        @Override
        public Either<L, R> filterWith(Predicate<R> f, Supplier<L> v) {
            if (f.test(this.value)) {
                return this;
            }
            return new Left(v.get());
        }

        @Override
        public void consume(Consumer<L> f, Consumer<R> g) {
            g.accept(this.value);
        }

        @Override
        public <T> T foldWith(Function<L, T> f, Function<R, T> g) {
            return g.apply(this.value);
        }

        @Override
        public Optional<R> toOptional() {
            return Optional.ofNullable(this.value);
        }
    }

    public static class Left<L, R>
    extends Either<L, R> {
        final L value;

        private Left(L value) {
            this.value = value;
        }

        @Override
        public L left() {
            return this.value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public <M> Left<M, R> mapLeft(Function<L, M> f) {
            return new Left<M, R>(f.apply(this.value));
        }

        @Override
        public <S> Left<L, S> map(Function<R, S> f) {
            return this;
        }

        @Override
        public <S> Left<L, S> flatMap(Function<R, Either<L, S>> f) {
            return this;
        }

        @Override
        public Left<L, R> forEach(Consumer<R> f) {
            return this;
        }

        @Override
        public Right<L, R> recover(Function<L, R> f) {
            return new Right(f.apply(this.value));
        }

        @Override
        public Either<L, R> recoverWith(Function<L, Either<L, R>> f) {
            return f.apply(this.value);
        }

        @Override
        public Left<L, R> filter(Predicate<R> f, L v) {
            return this;
        }

        @Override
        public Left<L, R> filterWith(Predicate<R> f, Supplier<L> v) {
            return this;
        }

        @Override
        public void consume(Consumer<L> f, Consumer<R> g) {
            f.accept(this.value);
        }

        @Override
        public <T> T foldWith(Function<L, T> f, Function<R, T> g) {
            return f.apply(this.value);
        }

        @Override
        public Optional<R> toOptional() {
            return Optional.empty();
        }
    }
}

