// Generated by delombok at Thu Jun 04 12:24:18 CEST 2015
package de.scravy.machina;

import lombok.NonNull;
import de.scravy.cons.Cons;

/**
 * A value class that represents a transition, with an optional guard attached.
 *
 * @since 1.0.0
 * @author Julian Fleischer
 *
 * @param <S>
 * State
 * @param <T>
 * Event Type
 */
public final class Transition<S, T> {
  @NonNull
  private final S fromState;
  private final T eventType;
  @NonNull
  private final S toState;
  private final Guard<?, ?> guard;

  public Transition(final S fromState, final T eventType, final S toState) {
    this(fromState, eventType, toState, null);
  }

  /**
   * A TransitionBuilder that builds transitions.
   *
   * @author Julian Fleischer
   * @since 1.2.0
   *
   * @param <S>
   * State. This builder is not aware of the Event Type yet.
   */
  public static class TransitionBuilder<S> {
    final S state;

    /**
     * @since 1.2.0
     * @param eventType
     * @param to
     * @return
     */
    public <T> TransitionBuilder2<S, T> on(final T eventType, final S to) {
      return new TransitionBuilder2<S, T>(Cons.singleton(new Transition<S, T>(state, eventType, to)));
    }

    /**
     * @since 1.2.0
     * @param eventType
     * @param to
     * @param guard
     * @return
     */
    @SuppressWarnings("rawtypes")
    public <T> TransitionBuilder2<S, T> on(final T eventType, final S to, final String guard) {
      return new TransitionBuilder2<S, T>(Cons.singleton(new Transition<S, T>(state, eventType, to, new ExpressionGuard(guard))));
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    private TransitionBuilder(final S state) {
      this.state = state;
    }
  }

  /**
   * A TransitionBuilder that builds transitions.
   *
   * The difference to {@link de.scravy.machina.Transition.TransitionBuilder} is
   * that it does not know the Event Type yet, this transition builder OTOH
   * does.
   *
   * @author Julian Fleischer
   * @since 1.2.0
   *
   * @param <S>
   * State.
   * @param <T>
   * Event Type.
   */
  public static class TransitionBuilder2<S, T> {
    final Cons<Transition<S, T>> transitions;

    /**
     * @since 1.2.0
     * @param eventType
     * @param to
     * @return
     */
    public TransitionBuilder2<S, T> on(final T eventType, final S to) {
      return new TransitionBuilder2<S, T>(transitions.cons(new Transition<S, T>(transitions.getHead().getFromState(), eventType, to)));
    }

    /**
     * If no transition was eligible, fallback to this transition.
     *
     * This is the same as {@link #catchall(Object)}.
     *
     * @since 1.2.0
     * @param to
     * @return
     */
    public TransitionBuilder2<S, T> fallback(final S to) {
      return catchall(to);
    }

    /**
     * If no transition was eligible, fallback to this transition.
     *
     * @since 1.3.0
     * @param to
     * @return
     */
    public TransitionBuilder2<S, T> catchall(final S to) {
      return new TransitionBuilder2<S, T>(transitions.cons(new Transition<S, T>(transitions.getHead().getFromState(), null, to)));
    }

    /**
     * @since 1.2.0
     * @param eventType
     * @param to
     * @param guard
     * @return
     */
    @SuppressWarnings("rawtypes")
    public TransitionBuilder2<S, T> on(final T eventType, final S to, final String guard) {
      return new TransitionBuilder2<S, T>(transitions.cons(new Transition<S, T>(transitions.getHead().getFromState(), eventType, to, new ExpressionGuard(guard))));
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    private TransitionBuilder2(final Cons<Transition<S, T>> transitions) {
      this.transitions = transitions;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    Cons<Transition<S, T>> getTransitions() {
      return this.transitions;
    }
  }

  /**
   * @since 1.2.0
   * @param state
   * @return
   */
  public static <S> TransitionBuilder<S> from(final S state) {
    return new TransitionBuilder<S>(state);
  }

  @NonNull
  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public S getFromState() {
    return this.fromState;
  }

  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public T getEventType() {
    return this.eventType;
  }

  @NonNull
  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public S getToState() {
    return this.toState;
  }

  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public Guard<?, ?> getGuard() {
    return this.guard;
  }

  @Override
  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public boolean equals(final Object o) {
    if (o == this) return true;
    if (!(o instanceof Transition)) return false;
    final Transition<?, ?> other = (Transition<?, ?>)o;
    final Object this$fromState = this.getFromState();
    final Object other$fromState = other.getFromState();
    if (this$fromState == null ? other$fromState != null : !this$fromState.equals(other$fromState)) return false;
    final Object this$eventType = this.getEventType();
    final Object other$eventType = other.getEventType();
    if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) return false;
    final Object this$toState = this.getToState();
    final Object other$toState = other.getToState();
    if (this$toState == null ? other$toState != null : !this$toState.equals(other$toState)) return false;
    final Object this$guard = this.getGuard();
    final Object other$guard = other.getGuard();
    if (this$guard == null ? other$guard != null : !this$guard.equals(other$guard)) return false;
    return true;
  }

  @Override
  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final Object $fromState = this.getFromState();
    result = result * PRIME + ($fromState == null ? 0 : $fromState.hashCode());
    final Object $eventType = this.getEventType();
    result = result * PRIME + ($eventType == null ? 0 : $eventType.hashCode());
    final Object $toState = this.getToState();
    result = result * PRIME + ($toState == null ? 0 : $toState.hashCode());
    final Object $guard = this.getGuard();
    result = result * PRIME + ($guard == null ? 0 : $guard.hashCode());
    return result;
  }

  @Override
  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public String toString() {
    return "Transition(fromState=" + this.getFromState() + ", eventType=" + this.getEventType() + ", toState=" + this.getToState() + ", guard=" + this.getGuard() + ")";
  }

  @java.beans.ConstructorProperties({"fromState", "eventType", "toState", "guard"})
  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public Transition(@NonNull final S fromState, final T eventType, @NonNull final S toState, final Guard<?, ?> guard) {
    if (fromState == null) {
      throw new IllegalArgumentException("fromState is null");
    }
    if (toState == null) {
      throw new IllegalArgumentException("toState is null");
    }
    this.fromState = fromState;
    this.eventType = eventType;
    this.toState = toState;
    this.guard = guard;
  }
}