// Generated by delombok at Sun May 24 02:54:45 CEST 2015
package de.scravy.machina;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.MVEL;

/**
 * A Guard which is defined by an MVEL expression.
 *
 * @author Julian Fleischer
 *
 * @since 1.0.0
 *
 * @param <C>
 * Context
 */
public final class ExpressionGuard<E, C> implements Guard<E, C>, Serializable {
  private static final long serialVersionUID = 1L;
  private final String expression;
  private final Serializable compiledExpression;

  /**
   * Create a condition with an MVEL expression as guard.
   *
   * @since 1.0.0
   *
   * @param expression
   * The expression. You can use the variables <code>e</code>,
   * <code>event</code>, <code>c</code>, and <code>context</code> to
   * refer to the event of type <code>E</code> and the context of type
   * <code>C</code>.
   * @throws InvalidExpressionException
   * If the expression failed to compile.
   */
  public ExpressionGuard(final String expression) throws InvalidExpressionException {
    try {
      this.compiledExpression = MVEL.compileExpression(expression);
      this.expression = expression;
    } catch (final CompileException exc) {
      throw new InvalidExpressionException(exc);
    }
  }

  private static <C, E> Map<String, Object> evaluationContext(final E event, final C context) {
    final Map<String, Object> map = new HashMap<>();
    map.put("e", event);
    map.put("event", event);
    map.put("c", context);
    map.put("context", context);
    return map;
  }

  @Override
  public boolean evaluate(final E event, final C context) {
    try {
      final Object result = MVEL.executeExpression(this.compiledExpression, evaluationContext(event, context));
      if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
        return true;
      }
      return false;
    } catch (final Exception exc) {
      throw new GuardEvaluationException(this.expression, exc);
    }
  }

  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public String getExpression() {
    return this.expression;
  }

  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public Serializable getCompiledExpression() {
    return this.compiledExpression;
  }

  @Override
  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public String toString() {
    return "ExpressionGuard(expression=" + this.getExpression() + ", compiledExpression=" + this.getCompiledExpression() + ")";
  }

  @Override
  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public boolean equals(final Object o) {
    if (o == this) return true;
    if (!(o instanceof ExpressionGuard)) return false;
    final ExpressionGuard<?, ?> other = (ExpressionGuard<?, ?>)o;
    final Object this$expression = this.getExpression();
    final Object other$expression = other.getExpression();
    if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) return false;
    return true;
  }

  @Override
  @SuppressWarnings("all")
  @javax.annotation.Generated("lombok")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final Object $expression = this.getExpression();
    result = result * PRIME + ($expression == null ? 0 : $expression.hashCode());
    return result;
  }
}