/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.jazz.grids;

import de.scravy.jazz.Event;
import de.scravy.jazz.Picture;
import de.scravy.jazz.Vector;
import de.scravy.jazz.annotation.Experimental;
import de.scravy.jazz.grids.AbstractGrid;
import de.scravy.jazz.grids.TileEventHandler;
import de.scravy.jazz.grids.TileFactory;
import de.scravy.jazz.grids.TileRenderer;
import de.scravy.jazz.pictures.UnmodifieablePictures;
import de.scravy.jazz.pictures.mutable.Pictures;

@Experimental
public class RectangularGrid<T>
extends AbstractGrid<RectangularGrid<T>, T> {
    private final int gridWidth;
    private final int gridHeight;
    private final T[][] tiles;

    public RectangularGrid(int width, int height, double tileWidth, double tileHeight, TileFactory<T> tileFactory, TileEventHandler<T> tileHandler, TileRenderer<T> tileRenderer) {
        super(tileHandler, tileRenderer, (double)width * tileWidth, (double)height * tileHeight);
        this.gridWidth = width;
        this.gridHeight = height;
        this.tiles = new Object[this.gridWidth][this.gridHeight];
        for (int x = 0; x < this.gridWidth; ++x) {
            for (int y = 0; y < this.gridHeight; ++y) {
                this.tiles[x][y] = tileFactory.createTile(x, y);
            }
        }
    }

    @Override
    public void on(Event e) {
        Vector c = this.getLowerLeftCorner();
        Vector p = e.getPosition();
        int x = (int)(p.getX() - c.getX());
        int y = (int)(p.getY() - c.getY());
        if (x >= 0 && y >= 0 && (double)x < this.width && (double)y < this.height) {
            x = (int)((double)x / (this.width / (double)this.gridWidth));
            y = (int)((double)y / (this.height / (double)this.gridHeight));
            this.tileHandler.on(e, this.tiles[x][y]);
        }
    }

    public T getTileAt(int x, int y) {
        return this.tiles[x][y];
    }

    @Override
    public Picture getPicture() {
        Pictures pictures = new Pictures(new Picture[0]);
        double tileWidth = this.getWidth() / (double)this.gridWidth;
        double tileHeight = this.getHeight() / (double)this.gridHeight;
        Vector p = this.getLowerLeftCorner();
        double posX = p.getX() + tileWidth / 2.0;
        double upperY = p.getY() + tileHeight / 2.0;
        for (int x = 0; x < this.gridWidth; ++x) {
            double posY = upperY;
            for (int y = 0; y < this.gridHeight; ++y) {
                pictures.add(this.tileRenderer.render(this.tiles[x][y], posX, posY, tileWidth, tileHeight));
                posY += tileHeight;
            }
            posX += tileWidth;
        }
        return new UnmodifieablePictures(pictures);
    }
}

