/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.jazz.grids;

import de.scravy.jazz.Event;
import de.scravy.jazz.Picture;
import de.scravy.jazz.Vector;
import de.scravy.jazz.annotation.Experimental;
import de.scravy.jazz.grids.TileDecorator;
import de.scravy.jazz.grids.TileEventHandler;
import de.scravy.jazz.grids.TileFactory;
import de.scravy.jazz.grids.TilePos;
import de.scravy.jazz.pictures.mutable.Pictures;
import de.scravy.jazz.pictures.mutable.Polygon;

@Experimental
public class HexagonGrid<T> {
    private final TileEventHandler<T> tileHandler;
    private final TileDecorator<T> tileDecorator;
    private final int height;
    private final int width;
    private final double a;
    private final double w;
    private final double h;
    private final double w1;
    private final double w2;
    private final double h1;
    private final double h2;
    private final T[][] tiles;

    public HexagonGrid(TileFactory<T> tileFactory, TileDecorator<T> tileDecorator, TileEventHandler<T> tileHandler, double a, int width, int height) {
        this.tileDecorator = tileDecorator;
        this.tileHandler = tileHandler;
        this.width = width;
        this.height = height;
        this.a = a;
        this.tiles = new Object[width][height];
        this.w1 = Math.sqrt(3.0) * a;
        this.w2 = this.w1 / 2.0;
        this.h1 = a / 2.0;
        this.h2 = this.h1 * 3.0;
        this.w = (double)width * this.w1 + this.w2;
        this.h = (double)height * this.h2 + this.h1;
    }

    public Picture getPicture() {
        Pictures pictures = new Pictures(new Picture[0]);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                double x = (double)i * this.w1 - this.w / 2.0;
                double y = (double)j * this.h2 - this.h / 2.0;
                if (j % 2 != 0) {
                    x += this.w2;
                }
                Polygon p = new Polygon(new Vector[]{new Vector(x + this.w2, y), new Vector(x + this.w1, y + this.h1), new Vector(x + this.w1, y + this.h2), new Vector(x + this.w2, y + 2.0 * this.a), new Vector(x, y + this.h2), new Vector(x, y + this.h1)});
                pictures.add(this.tileDecorator.decorate(this.tiles[i][j], (Picture)p));
            }
        }
        return pictures;
    }

    public void on(Event ev) {
    }

    public void setTileAt(int x, int y, T tile) {
        this.tiles[x][y] = tile;
    }

    public void setTileAt(TilePos p, T tile) {
        this.tiles[p.x][p.y] = tile;
    }

    public T getTileAt(int x, int y) {
        return this.tiles[x][y];
    }

    public T getTileAt(TilePos p) {
        return this.tiles[p.x][p.y];
    }

    public TilePos topLeft(TilePos p) {
        if (p.y + 1 >= this.height) {
            return null;
        }
        if (p.y % 2 == 0) {
            return p.x == 0 ? null : new TilePos(p.x - 1, p.y + 1);
        }
        return new TilePos(p.x, p.y + 1);
    }

    public TilePos topRight(TilePos p) {
        if (p.y + 1 >= this.height) {
            return null;
        }
        if (p.y % 2 == 0) {
            return new TilePos(p.x, p.y + 1);
        }
        return p.x + 1 >= this.width ? null : new TilePos(p.x + 1, p.y + 1);
    }

    public TilePos bottomLeft(TilePos p) {
        if (p.y == 0) {
            return null;
        }
        if (p.y % 2 == 0) {
            return p.x == 0 ? null : new TilePos(p.x - 1, p.y - 1);
        }
        return new TilePos(p.x, p.y - 1);
    }

    public TilePos bottomRight(TilePos p) {
        if (p.y == 0) {
            return null;
        }
        if (p.y % 2 == 0) {
            return new TilePos(p.x, p.y - 1);
        }
        return p.x + 1 >= this.width ? null : new TilePos(p.x + 1, p.y - 1);
    }

    public TilePos left(TilePos p) {
        return p.x == 0 ? null : new TilePos(p.x - 1, p.y);
    }

    public TilePos right(TilePos p) {
        return p.x + 1 >= this.width ? null : new TilePos(p.x + 1, p.y);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

