/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.jazz.grids;

import de.scravy.jazz.Vector;
import de.scravy.jazz.annotation.Experimental;
import de.scravy.jazz.grids.Grid;
import de.scravy.jazz.grids.TileEventHandler;
import de.scravy.jazz.grids.TileRenderer;

@Experimental
public abstract class AbstractGrid<A, T>
implements Grid<A, T> {
    protected Vector center = Vector.ZERO;
    protected double width;
    protected double height;
    protected final TileEventHandler<T> tileHandler;
    protected final TileRenderer<T> tileRenderer;

    public AbstractGrid(TileEventHandler<T> tileHandler, TileRenderer<T> tileRenderer, double width, double height) {
        this.tileHandler = tileHandler;
        this.tileRenderer = tileRenderer;
        this.setWidth(width);
        this.setHeight(height);
    }

    @Override
    public A setCenter(Vector p) {
        this.center = p;
        return (A)this;
    }

    @Override
    public A setCenter(double x, double y) {
        this.center = new Vector(x, y);
        return (A)this;
    }

    @Override
    public Vector getCenter() {
        return this.center;
    }

    @Override
    public A setWidth(double width) {
        this.width = width;
        return (A)this;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public A setHeight(double height) {
        this.height = height;
        return (A)this;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public A setLowerLeftCorner(Vector p, boolean resize) {
        if (resize) {
            Vector c = this.getUpperRightCorner();
            this.setWidth(Math.abs(p.getX() - c.getX()));
            this.setHeight(Math.abs(p.getY() - c.getY()));
            this.setCenter((p.getX() + c.getX()) / 2.0, (p.getY() + c.getY()) / 2.0);
        } else {
            this.setCenter(new Vector(p.getX() + this.width / 2.0, p.getY() + this.height / 2.0));
        }
        return (A)this;
    }

    @Override
    public Vector getLowerLeftCorner() {
        return new Vector(this.center.getX() - this.width / 2.0, this.center.getY() - this.height / 2.0);
    }

    @Override
    public A setUpperLeftCorner(Vector p, boolean resize) {
        if (resize) {
            Vector c = this.getLowerRightCorner();
            this.setWidth(Math.abs(p.getX() - c.getX()));
            this.setHeight(Math.abs(p.getY() - c.getY()));
            this.setCenter((p.getX() + c.getX()) / 2.0, (p.getY() + c.getY()) / 2.0);
        } else {
            this.setCenter(new Vector(p.getX() + this.width / 2.0, p.getY() - this.height / 2.0));
        }
        return (A)this;
    }

    @Override
    public Vector getUpperLeftCorner() {
        return new Vector(this.center.getX() - this.width / 2.0, this.center.getY() + this.height / 2.0);
    }

    @Override
    public A setLowerRightCorner(Vector p, boolean resize) {
        if (resize) {
            Vector c = this.getUpperLeftCorner();
            this.setWidth(Math.abs(p.getX() - c.getX()));
            this.setHeight(Math.abs(p.getY() - c.getY()));
            this.setCenter((p.getX() + c.getX()) / 2.0, (p.getY() + c.getY()) / 2.0);
        } else {
            this.setCenter(new Vector(p.getX() - this.width / 2.0, p.getY() + this.height / 2.0));
        }
        return (A)this;
    }

    @Override
    public Vector getLowerRightCorner() {
        return new Vector(this.center.getX() + this.width / 2.0, this.center.getY() - this.height / 2.0);
    }

    @Override
    public A setUpperRightCorner(Vector p, boolean resize) {
        if (resize) {
            Vector c = this.getLowerLeftCorner();
            this.setWidth(Math.abs(p.getX() - c.getX()));
            this.setHeight(Math.abs(p.getY() - c.getY()));
            this.setCenter((p.getX() + c.getX()) / 2.0, (p.getY() + c.getY()) / 2.0);
        } else {
            this.setCenter(new Vector(p.getX() - this.width / 2.0, p.getY() - this.height / 2.0));
        }
        return (A)this;
    }

    @Override
    public Vector getUpperRightCorner() {
        return new Vector(this.center.getX() + this.width / 2.0, this.center.getY() + this.height / 2.0);
    }
}

