/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.either;

import java.beans.ConstructorProperties;

public abstract class Either<L, R> {
    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> left(L value, Class<R> rightType) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public static <L, R> Either<L, R> right(R value, Class<L> leftType) {
        return new Right(value);
    }

    private Either() {
    }

    public boolean isLeft() {
        return false;
    }

    public boolean isRight() {
        return false;
    }

    public L getLeft() {
        throw new UnsupportedOperationException();
    }

    public R getRight() {
        throw new UnsupportedOperationException();
    }

    public static final class Right<L, R>
    extends Either<L, R> {
        private final R right;

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public R getRight() {
            return this.right;
        }

        @ConstructorProperties(value={"right"})
        public Right(R right) {
            this.right = right;
        }

        public String toString() {
            return "Either.Right(right=" + this.getRight() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Right)) {
                return false;
            }
            Right other = (Right)o;
            if (!other.canEqual(this)) {
                return false;
            }
            R this$right = this.getRight();
            R other$right = other.getRight();
            return !(this$right == null ? other$right != null : !this$right.equals(other$right));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Right;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            R $right = this.getRight();
            result = result * 59 + ($right == null ? 0 : $right.hashCode());
            return result;
        }
    }

    public static final class Left<L, R>
    extends Either<L, R> {
        private final L left;

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public L getLeft() {
            return this.left;
        }

        @ConstructorProperties(value={"left"})
        public Left(L left) {
            this.left = left;
        }

        public String toString() {
            return "Either.Left(left=" + this.getLeft() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Left)) {
                return false;
            }
            Left other = (Left)o;
            if (!other.canEqual(this)) {
                return false;
            }
            L this$left = this.getLeft();
            L other$left = other.getLeft();
            return !(this$left == null ? other$left != null : !this$left.equals(other$left));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Left;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            L $left = this.getLeft();
            result = result * 59 + ($left == null ? 0 : $left.hashCode());
            return result;
        }
    }
}

