/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.cons;

import de.scravy.pair.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class Cons<E>
implements Pair<E, Cons<E>>,
Iterable<E> {
    private static final Cons<?> EMPTY = new Cons<Object>(null, null);
    private final E head;
    private final Cons<E> tail;

    public static <E> Cons<E> singleton(E value) {
        return new Cons<E>(value, EMPTY);
    }

    public static <E> Cons<E> empty() {
        return EMPTY;
    }

    public static <E> Cons<E> cons(E head, Cons<E> tail) {
        if (tail == null) {
            throw new IllegalArgumentException();
        }
        return new Cons<E>(head, tail);
    }

    public Cons<E> cons(E head) {
        return Cons.cons(head, this);
    }

    @SafeVarargs
    public static <E> Cons<E> fromArray(E ... array) {
        Cons<E> current = Cons.empty();
        for (int i = array.length - 1; i >= 0; --i) {
            current = Cons.cons(array[i], current);
        }
        return current;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public int getLength() {
        int count = 0;
        Cons<E> current = this;
        while (current != EMPTY) {
            ++count;
            current = current.tail;
        }
        return count;
    }

    public List<E> toList() {
        ArrayList list = new ArrayList(this.getLength());
        return this.toCollection(list);
    }

    public <C extends Collection<E>> C toCollection(C collection) {
        Cons<E> current = this;
        while (current != EMPTY) {
            collection.add(current.head);
            current = current.tail;
        }
        return collection;
    }

    public E get(int ix) {
        Cons<E> current = this;
        for (int i = 0; i < ix && current != EMPTY; ++i) {
            current = current.tail;
        }
        if (current == EMPTY) {
            throw new NoSuchElementException();
        }
        return current.head;
    }

    public E getFirst() {
        return this.head;
    }

    public Cons<E> getSecond() {
        return this.tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Cons<E> current;
            {
                this.current = Cons.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != EMPTY;
            }

            @Override
            public E next() {
                Object value = this.current.head;
                this.current = this.current.tail;
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public E getHead() {
        return this.head;
    }

    public Cons<E> getTail() {
        return this.tail;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cons)) {
            return false;
        }
        Cons other = (Cons)o;
        E this$head = this.getHead();
        E other$head = other.getHead();
        if (this$head == null ? other$head != null : !this$head.equals(other$head)) {
            return false;
        }
        Cons<E> this$tail = this.getTail();
        Cons<E> other$tail = other.getTail();
        return !(this$tail == null ? other$tail != null : !((Object)this$tail).equals(other$tail));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        E $head = this.getHead();
        result = result * 59 + ($head == null ? 0 : $head.hashCode());
        Cons<E> $tail = this.getTail();
        result = result * 59 + ($tail == null ? 0 : ((Object)$tail).hashCode());
        return result;
    }

    public String toString() {
        return "Cons(head=" + this.getHead() + ", tail=" + this.getTail() + ")";
    }

    private Cons(E head, Cons<E> tail) {
        this.head = head;
        this.tail = tail;
    }
}

