/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public final class UUIDs {
    public static final UUID NULL = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static final UUID NAMESPACE_DNS = UUID.fromString("6ba7b810-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_URL = UUID.fromString("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_OID = UUID.fromString("6ba7b812-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_X500 = UUID.fromString("6ba7b814-9dad-11d1-80b4-00c04fd430c8");

    private static byte[] namespacedBytes(UUID namespace, String name) {
        byte[] namespaceBytes = UUIDs.toBytes(namespace);
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[namespaceBytes.length + nameBytes.length]);
        buffer.put(namespaceBytes);
        buffer.put(nameBytes);
        return buffer.array();
    }

    public static UUID v3(UUID namespace, String name) {
        return UUID.nameUUIDFromBytes(UUIDs.namespacedBytes(namespace, name));
    }

    public static UUID v4() {
        return UUID.randomUUID();
    }

    public static UUID v5(UUID namespace, String name) {
        MessageDigest md;
        byte[] bytes = UUIDs.namespacedBytes(namespace, name);
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException exc) {
            throw new RuntimeException(exc);
        }
        byte[] resultBytes = md.digest(bytes);
        resultBytes[6] = (byte)(resultBytes[6] & 0xF);
        resultBytes[6] = (byte)(resultBytes[6] | 0x50);
        resultBytes[8] = (byte)(resultBytes[8] & 0x3F);
        resultBytes[8] = (byte)(resultBytes[8] | 0x80);
        return UUIDs.fromBytes(resultBytes);
    }

    public static byte[] toBytes(UUID uuid) {
        Objects.requireNonNull(uuid);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return buffer.array();
    }

    public static UUID fromBytes(byte[] bytes) {
        Objects.requireNonNull(bytes);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long mostSignificantBits = buffer.getLong();
        long leastSignificantBits = buffer.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    @Generated
    private UUIDs() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

