/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Pair;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.hlist.C;
import de.scravy.bedrock.hlist.HList;
import de.scravy.bedrock.hlist.Nil;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

public interface Tuple2<A, B> {
    public A getFirst();

    public B getSecond();

    @Nonnull
    default public List<Object> toList() {
        return Pair.toList(this);
    }

    @Nonnull
    default public Seq<Object> toSeq() {
        return Pair.toSeq(this);
    }

    @Nonnull
    default public C<A, C<B, Nil>> toHList2() {
        return HList.hlist(this.getFirst(), this.getSecond());
    }

    default public <R> R apply(@Nonnull BiFunction<A, B, R> f) {
        return f.apply(this.getFirst(), this.getSecond());
    }

    @Nonnull
    public static <C, A extends C, B extends C> Seq<C> toSeq(Tuple2<A, B> pair) {
        return Seq.of(pair.getFirst(), pair.getSecond());
    }
}

