/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import de.scravy.bedrock.Tuple3;
import de.scravy.bedrock.hlist.C;
import de.scravy.bedrock.hlist.HList;
import de.scravy.bedrock.hlist.Nil;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@Immutable
public final class Triple<A, B, C>
implements Serializable,
Comparable<Triple<A, B, C>>,
Tuple3<A, B, C> {
    private final A first;
    private final B second;
    private final C third;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(@Nonnull Triple<A, B, C> tuple) {
        int r;
        if (this.first == null) {
            if (tuple.first != null) return -1;
            r = 0;
        } else {
            if (tuple.first == null) {
                return 1;
            }
            r = ((Comparable)this.first).compareTo(tuple.first);
        }
        if (r != 0) {
            return r;
        }
        if (this.second == null) {
            if (tuple.second != null) return -1;
            r = 0;
        } else {
            if (tuple.second == null) {
                return 1;
            }
            r = ((Comparable)this.second).compareTo(tuple.second);
        }
        if (r != 0) {
            return r;
        }
        if (this.third == null) {
            if (tuple.third != null) return -1;
            return 0;
        }
        if (tuple.third != null) return ((Comparable)this.third).compareTo(tuple.third);
        return 1;
    }

    @Nonnull
    public static <D, A extends D, B extends D, C extends D> List<D> toList(final @Nonnull Tuple3<A, B, C> tuple) {
        return new AbstractList<D>(){

            @Override
            public D get(int index) {
                switch (index) {
                    case 0: {
                        return tuple.getFirst();
                    }
                    case 1: {
                        return tuple.getSecond();
                    }
                    case 2: {
                        return tuple.getThird();
                    }
                }
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }

            @Override
            public int size() {
                return 3;
            }
        };
    }

    @Nonnull
    public C<A, C<B, C<C, Nil>>> toHList() {
        return this.toHList3();
    }

    @Nonnull
    public static <A, B, C, L extends HList<L>> Triple<A, B, C> fromHList(@Nonnull C<A, C<B, C<C, L>>> hlist) {
        return Triple.triple(hlist.getHead(), hlist.getTail().getHead(), hlist.getTail().getTail().getHead());
    }

    @Nonnull
    public static <D, A extends D, B extends D, C extends D> Seq<D> toSeq(@Nonnull Tuple3<A, B, C> triple) {
        return Seq.of(triple.getFirst(), triple.getSecond(), triple.getThird());
    }

    @Nonnull
    public <D, E, F> Triple<D, E, F> map(@Nonnull Function<A, D> f, @Nonnull Function<B, E> g, @Nonnull Function<C, F> h) {
        return Triple.of(f.apply(this.getFirst()), g.apply(this.getSecond()), h.apply(this.getThird()));
    }

    @Nonnull
    public <D> Triple<D, B, C> mapFirst(@Nonnull Function<A, D> f) {
        Objects.requireNonNull(f, "Function 'f' must not be null");
        return Triple.of(f.apply(this.getFirst()), this.getSecond(), this.getThird());
    }

    @Nonnull
    public <D> Triple<A, D, C> mapSecond(@Nonnull Function<B, D> f) {
        Objects.requireNonNull(f, "Function 'f' must not be null");
        return Triple.of(this.getFirst(), f.apply(this.getSecond()), this.getThird());
    }

    @Nonnull
    public <D> Triple<A, B, D> mapThird(@Nonnull Function<C, D> f) {
        Objects.requireNonNull(f, "Function 'f' must not be null");
        return Triple.of(this.getFirst(), this.getSecond(), f.apply(this.getThird()));
    }

    @Nonnull
    public <D> Triple<D, B, C> withFirst(D v) {
        return Triple.of(v, this.getSecond(), this.getThird());
    }

    @Nonnull
    public <D> Triple<A, D, C> withSecond(D v) {
        return Triple.of(this.getFirst(), v, this.getThird());
    }

    @Nonnull
    public <D> Triple<A, B, D> withThird(D v) {
        return Triple.of(this.getFirst(), this.getSecond(), v);
    }

    public static <A, B, C> Triple<A, B, C> triple(A a, B b, C c) {
        return Triple.of(a, b, c);
    }

    @Generated
    private Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Generated
    public static <A, B, C> Triple<A, B, C> of(A first, B second, C third) {
        return new Triple<A, B, C>(first, second, third);
    }

    @Override
    @Generated
    public A getFirst() {
        return this.first;
    }

    @Override
    @Generated
    public B getSecond() {
        return this.second;
    }

    @Override
    @Generated
    public C getThird() {
        return this.third;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Triple)) {
            return false;
        }
        Triple other = (Triple)o;
        A this$first = this.getFirst();
        A other$first = other.getFirst();
        if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
            return false;
        }
        B this$second = this.getSecond();
        B other$second = other.getSecond();
        if (this$second == null ? other$second != null : !this$second.equals(other$second)) {
            return false;
        }
        C this$third = this.getThird();
        C other$third = other.getThird();
        return !(this$third == null ? other$third != null : !this$third.equals(other$third));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        A $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : $first.hashCode());
        B $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : $second.hashCode());
        C $third = this.getThird();
        result = result * 59 + ($third == null ? 43 : $third.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Triple(first=" + this.getFirst() + ", second=" + this.getSecond() + ", third=" + this.getThird() + ")";
    }
}

