/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import java.util.function.Consumer;

@FunctionalInterface
public interface ThrowingRunnable
extends Runnable {
    public void execute() throws Exception;

    @Override
    default public void run() {
        try {
            this.execute();
        }
        catch (Error | RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    default public Runnable safe(Consumer<? super Exception> errorHandler) {
        return () -> {
            try {
                this.execute();
            }
            catch (Exception exc) {
                errorHandler.accept(exc);
            }
        };
    }
}

