/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import java.util.function.Consumer;

@FunctionalInterface
public interface ThrowingConsumer<A>
extends Consumer<A> {
    public void consume(A var1) throws Exception;

    @Override
    default public void accept(A arg) {
        try {
            this.consume(arg);
        }
        catch (Error | RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    default public Consumer<A> safe(Consumer<? super Exception> errorHandler) {
        return arg -> {
            try {
                this.consume(arg);
            }
            catch (Exception exc) {
                errorHandler.accept(exc);
            }
        };
    }
}

