/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import java.util.function.BiConsumer;
import java.util.function.Consumer;

@FunctionalInterface
public interface ThrowingBiConsumer<A, B>
extends BiConsumer<A, B> {
    public void consume(A var1, B var2) throws Exception;

    @Override
    default public void accept(A arg1, B arg2) {
        try {
            this.consume(arg1, arg2);
        }
        catch (Error | RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    default public BiConsumer<A, B> safe(Consumer<? super Exception> errorHandler) {
        return (a1, a2) -> {
            try {
                this.consume(a1, a2);
            }
            catch (Exception exc) {
                errorHandler.accept(exc);
            }
        };
    }
}

