/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.ArrayMap;
import de.scravy.bedrock.Box;
import de.scravy.bedrock.Pair;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqBuilder;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public final class Strings {
    @Nonnull
    public static String capitalize(@Nonnull String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Strings.forEachCodepointWithIndex(string, (index, codepoint) -> {
            if (index == 0) {
                stringBuilder.appendCodePoint(Character.toUpperCase(codepoint));
            } else {
                stringBuilder.appendCodePoint(Character.toLowerCase(codepoint));
            }
        });
        return stringBuilder.toString();
    }

    @Nonnull
    public static String capitalizeFirstCharacter(@Nonnull String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Strings.forEachCodepointWithIndex(string, (index, codepoint) -> {
            if (index == 0) {
                stringBuilder.appendCodePoint(Character.toUpperCase(codepoint));
            } else {
                stringBuilder.appendCodePoint(codepoint);
            }
        });
        return stringBuilder.toString();
    }

    @Nonnull
    public static Seq<String> explode(@Nonnull String string, @Nonnull String delimiter) {
        Objects.requireNonNull(string, "'string' must not be null");
        Objects.requireNonNull(delimiter, "'delimiter' must not be null");
        if (string.isEmpty()) {
            return Seq.empty();
        }
        return Seq.ofArrayZeroCopyInternal(string.split(Pattern.quote(delimiter)));
    }

    @SafeVarargs
    @Nonnull
    public static String replace(@Nonnull String string, Pair<String, String> ... values) {
        Objects.requireNonNull(string, "'string' must not be null");
        Objects.requireNonNull(values, "'values' must not be null");
        ArrayMap<String, String> valuesMap = ArrayMap.of(values);
        String regex = valuesMap.keys().stream().map(Pattern::quote).collect(Collectors.joining("|"));
        Template template = Strings.template(regex, string);
        return template.apply((Function<String, String>)valuesMap);
    }

    @Nonnull
    public static Template template(@Nonnull String variableBeginDelimiter, @Nonnull String variableEndDelimiter, @Nonnull String template) {
        Objects.requireNonNull(variableBeginDelimiter, "'variableBeginDelimiter' must not be null");
        Objects.requireNonNull(variableEndDelimiter, "'variableEndDelimiter' must not be null");
        String quotedBeginDelimiter = Pattern.quote(variableBeginDelimiter);
        String quotedEndDelimiter = Pattern.quote(variableEndDelimiter);
        String nameRegex = "[a-zA-Z]([_\\-]?[a-zA-Z0-9])*";
        return Strings.template(quotedBeginDelimiter + "[a-zA-Z]([_\\-]?[a-zA-Z0-9])*" + quotedEndDelimiter, (String match) -> match.substring(variableBeginDelimiter.length(), match.length() - variableEndDelimiter.length()), template);
    }

    public static Template template(@Nonnull String regex, @Nonnull String template) {
        return Strings.template(regex, Function.identity(), template);
    }

    public static Template template(@Nonnull String regex, @Nonnull Function<String, String> nameExtractor, @Nonnull String template) {
        Objects.requireNonNull(regex, "'regex' must not be null");
        Objects.requireNonNull(nameExtractor, "'nameExtractor' must not be null");
        Objects.requireNonNull(template, "'template' must not be null");
        Pattern variablesPattern = Pattern.compile(regex);
        Matcher matcher = variablesPattern.matcher(template);
        SeqBuilder buildersBuilder = Seq.builder();
        int start = 0;
        int length = 0;
        while (matcher.find()) {
            int matchStartIndex = matcher.start();
            int matchEndIndex = matcher.end();
            String templateFragment = template.substring(start, matchStartIndex);
            if (!templateFragment.isEmpty()) {
                buildersBuilder.add(__ -> templateFragment);
                length += templateFragment.length();
            }
            String match = matcher.group(0);
            String variableName = nameExtractor.apply(match);
            buildersBuilder.add(variables -> (String)variables.apply(variableName));
            length += 20;
            start = matchEndIndex;
        }
        if (start < template.length()) {
            String endFragment = template.substring(start);
            buildersBuilder.add(__ -> endFragment);
            length += endFragment.length();
        }
        Object builders = buildersBuilder.result();
        final int sizeEstimate = length;
        return new Template((Seq)builders){
            final /* synthetic */ Seq val$builders;
            {
                this.val$builders = seq;
            }

            @Override
            @Nonnull
            public String apply(@Nonnull Function<String, String> values) {
                StringBuilder result = new StringBuilder(sizeEstimate);
                this.val$builders.forEach(f -> result.append((String)f.apply(values)));
                return result.toString();
            }
        };
    }

    public static void forEach(@Nonnull String string, @Nonnull IntConsumer consumer) {
        for (int i = 0; i < string.length(); ++i) {
            consumer.accept(string.charAt(i));
        }
    }

    public static void forEachCodepoint(@Nonnull String string, @Nonnull IntConsumer consumer) {
        for (int i = 0; i < string.length(); ++i) {
            char c1 = string.charAt(i);
            if (Character.isHighSurrogate(c1)) {
                char c2;
                if (++i >= string.length() || !Character.isLowSurrogate(c2 = string.charAt(i))) continue;
                int codepoint = Character.toCodePoint(c1, c2);
                consumer.accept(codepoint);
                continue;
            }
            consumer.accept(c1);
        }
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNonEmpty(@Nullable String string) {
        return !Strings.isNullOrEmpty(string);
    }

    public static boolean isNullOrBlank(@Nullable String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean isNonBlank(@Nullable String string) {
        return !Strings.isNullOrBlank(string);
    }

    public static void forEachCodepointWithIndex(@Nonnull String string, @Nonnull CodepointWithIndexConsumer consumer) {
        for (int i = 0; i < string.length(); ++i) {
            char c1 = string.charAt(i);
            if (Character.isHighSurrogate(c1)) {
                char c2;
                int j = i + 1;
                if (j < string.length() && Character.isLowSurrogate(c2 = string.charAt(j))) {
                    int codepoint = Character.toCodePoint(c1, c2);
                    consumer.accept(j, codepoint);
                }
                i = j;
                continue;
            }
            consumer.accept(i, c1);
        }
    }

    @Nonnull
    public static String toUpperCamelCase(@Nonnull String string) {
        return Strings.parseName(string).renderUpperCamelCase();
    }

    @Nonnull
    public static String toLowerCamelCase(@Nonnull String string) {
        return Strings.parseName(string).renderLowerCamelCase();
    }

    @Nonnull
    public static String toLowerKebapCase(@Nonnull String string) {
        return Strings.parseName(string).renderLowerKebapCase();
    }

    @Nonnull
    public static String toKebapCamelCase(@Nonnull String string) {
        return Strings.parseName(string).renderKebapCamelCase();
    }

    @Nonnull
    public static String toUpperSnakeCase(@Nonnull String string) {
        return Strings.parseName(string).renderUpperSnakeCase();
    }

    @Nonnull
    public static String toLowerSnakeCase(@Nonnull String string) {
        return Strings.parseName(string).renderLowerSnakeCase();
    }

    @Nonnull
    public static Name parseName(@Nonnull String name) {
        StringBuilder componentBuilder = new StringBuilder();
        SeqBuilder nameBuilder = Seq.builder();
        Strings.forEachCodepoint(name, codepoint -> {
            if (Character.isLetterOrDigit(codepoint)) {
                componentBuilder.appendCodePoint(codepoint);
            } else if (componentBuilder.length() > 0) {
                nameBuilder.add(componentBuilder.toString());
                componentBuilder.setLength(0);
            }
        });
        if (componentBuilder.length() > 0) {
            nameBuilder.add(componentBuilder.toString());
        }
        Object components = nameBuilder.result();
        Seq<String> finalNameComponents = ((Seq)components).flatMap(component -> {
            componentBuilder.setLength(0);
            nameBuilder.clear();
            Box.IntBox previousCodepoint = Box.intBox(-1);
            Strings.forEachCodepoint(component, codepoint -> {
                if (previousCodepoint.intExists(c -> c > -1)) {
                    if (Character.isUpperCase(codepoint) && !previousCodepoint.intExists(Character::isUpperCase)) {
                        componentBuilder.appendCodePoint(Character.toLowerCase(previousCodepoint.get()));
                        nameBuilder.add(componentBuilder.toString());
                        componentBuilder.setLength(0);
                    } else {
                        if (!Character.isUpperCase(codepoint) && previousCodepoint.intExists(Character::isUpperCase) && componentBuilder.length() > 0) {
                            nameBuilder.add(componentBuilder.toString());
                            componentBuilder.setLength(0);
                        }
                        componentBuilder.appendCodePoint(Character.toLowerCase(previousCodepoint.get()));
                    }
                }
                previousCodepoint.setValue(codepoint);
            });
            componentBuilder.appendCodePoint(Character.toLowerCase(previousCodepoint.get()));
            nameBuilder.add(componentBuilder.toString());
            return nameBuilder.result();
        });
        return new Name(finalNameComponents);
    }

    @Generated
    private Strings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    static interface CodepointWithIndexConsumer
    extends BiConsumer<Integer, Integer> {
        @Override
        public void accept(int var1, int var2);

        @Override
        default public void accept(@Nonnull Integer a, @Nonnull Integer b) {
            this.accept((int)a, (int)b);
        }
    }

    public static abstract class Template
    implements Function<Function<String, String>, String> {
        @SafeVarargs
        @Nonnull
        public final String substitute(Pair<String, String> ... values) {
            return this.apply((Function<String, String>)ArrayMap.of(values));
        }

        @Override
        @Nonnull
        public abstract String apply(@Nonnull Function<String, String> var1);
    }

    public static final class Name {
        private final Seq<String> components;

        @Nonnull
        public String renderLowerCamelCase() {
            StringBuilder stringBuilder = new StringBuilder();
            this.components.forEachWithIndex((index, component) -> {
                if (index == 0) {
                    stringBuilder.append((String)component);
                } else {
                    stringBuilder.append(Strings.capitalizeFirstCharacter(component));
                }
            });
            return stringBuilder.toString();
        }

        @Nonnull
        public String renderUpperCamelCase() {
            StringBuilder stringBuilder = new StringBuilder();
            this.components.forEach(component -> stringBuilder.append(Strings.capitalize(component)));
            return stringBuilder.toString();
        }

        @Nonnull
        public String renderUpperSnakeCase() {
            StringBuilder stringBuilder = new StringBuilder();
            this.components.forEachWithIndex((index, component) -> {
                if (index != 0) {
                    stringBuilder.append('_');
                }
                stringBuilder.append(component.toUpperCase());
            });
            return stringBuilder.toString();
        }

        @Nonnull
        public String renderLowerSnakeCase() {
            StringBuilder stringBuilder = new StringBuilder();
            this.components.forEachWithIndex((index, component) -> {
                if (index != 0) {
                    stringBuilder.append('_');
                }
                stringBuilder.append((String)component);
            });
            return stringBuilder.toString();
        }

        @Nonnull
        public String renderKebapCamelCase() {
            StringBuilder stringBuilder = new StringBuilder();
            this.components.forEachWithIndex((index, component) -> {
                if (index != 0) {
                    stringBuilder.append('-');
                }
                stringBuilder.append(Strings.capitalizeFirstCharacter(component));
            });
            return stringBuilder.toString();
        }

        @Nonnull
        public String renderLowerKebapCase() {
            StringBuilder stringBuilder = new StringBuilder();
            this.components.forEachWithIndex((index, component) -> {
                if (index != 0) {
                    stringBuilder.append('-');
                }
                stringBuilder.append((String)component);
            });
            return stringBuilder.toString();
        }

        @Generated
        public Seq<String> getComponents() {
            return this.components;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Name)) {
                return false;
            }
            Name other = (Name)o;
            Seq<String> this$components = this.getComponents();
            Seq<String> other$components = other.getComponents();
            return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Seq<String> $components = this.getComponents();
            result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Strings.Name(components=" + this.getComponents() + ")";
        }

        @Generated
        Name(Seq<String> components) {
            this.components = components;
        }
    }
}

