/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Cons;
import de.scravy.bedrock.Container;
import de.scravy.bedrock.Pair;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.hlist.C;
import de.scravy.bedrock.hlist.HList;
import de.scravy.bedrock.hlist.Nil;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class SpecificityTree<K extends HList<K>, V>
extends AbstractMap<K, V>
implements Container<Pair<K, V>> {
    @Nonnull
    private final Seq<String> dimensionNames;
    @Nonnull
    private final Map<K, V> items;

    private SpecificityTree(Iterable<String> dimensions, Class<?> underlyingMap) {
        Objects.requireNonNull(underlyingMap, "'underlyingMap' must not be null");
        this.dimensionNames = Seq.ofIterable(dimensions);
        this.items = (Map)underlyingMap.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private SpecificityTree(Iterable<String> dimensions) {
        this(dimensions, HashMap.class);
    }

    @Override
    @Nonnull
    public Iterator<Pair<K, V>> iterator() {
        return this.entrySet().stream().map(Pair::of).iterator();
    }

    @Nonnull
    public static <T> Builder<C<T, Nil>> withDimension(@Nonnull String name, @Nonnull Class<T> clazz) {
        return new Builder<C<T, Nil>>(Cons.singleton(name));
    }

    public SpecificityTree<K, V> add(@Nonnull K key, @Nonnull V value) {
        this.items.put(key, value);
        return this;
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value) {
        return this.items.put(key, value);
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.items.entrySet();
    }

    public static <K extends HList<K>> long computeSpecificityFor(K key) {
        if (key.isEmpty()) {
            return 0L;
        }
        return key.foldr((thing, spec) -> (spec << 1) + (long)(thing == null ? 0 : 1), 0L);
    }

    @Override
    @Nullable
    public V get(K key) {
        long keySpecificity;
        for (long specificity = keySpecificity = SpecificityTree.computeSpecificityFor(key); specificity >= 0L; --specificity) {
            long s;
            Object k;
            V value;
            if ((keySpecificity & specificity) != specificity || (value = this.items.get(k = ((HList)key).mask((arg_0, arg_1) -> SpecificityTree.lambda$get$1(s = specificity, arg_0, arg_1)))) == null) continue;
            return value;
        }
        return null;
    }

    @Nonnull
    @Generated
    public Seq<String> getDimensionNames() {
        return this.dimensionNames;
    }

    private static /* synthetic */ boolean lambda$get$1(long s, int ix, Object obj) {
        return (s & 1L << ix) != 0L;
    }

    public static class Builder<L extends HList<L>> {
        private final Cons<String> dimensions;

        public <T> Builder<C<T, L>> withDimension(String name, Class<T> clazz) {
            return new Builder<C<T, L>>(Cons.cons(name, this.dimensions));
        }

        @Nonnull
        public <V> SpecificityTree<L, V> build() {
            return new SpecificityTree(this.dimensions);
        }

        @Nonnull
        public <V, M extends Map<?, ?>> SpecificityTree<L, V> build(@Nonnull Class<M> underlyingMap) {
            return new SpecificityTree(this.dimensions, underlyingMap);
        }

        @Nonnull
        public <V, M extends Map<?, ?>> SpecificityTree<L, V> build(@Nonnull Class<M> underlyingMap, Class<V> valueType) {
            return this.build(underlyingMap);
        }

        @Generated
        private Builder(Cons<String> dimensions) {
            this.dimensions = dimensions;
        }
    }
}

