/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.AbstractBuilder;
import de.scravy.bedrock.Set;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public final class SetBuilder<E extends Comparable<? super E>>
extends AbstractBuilder<E, Set<E>, SetBuilder<E>> {
    private final SortedSet<E> underlyingSet = new TreeSet(Comparator.nullsFirst(Comparable::compareTo));

    @Override
    @Nonnull
    public Set<E> result() {
        return Set.ofSortedSet(this.underlyingSet);
    }

    @Override
    @Nonnull
    public SetBuilder<E> add(E elem) {
        this.underlyingSet.add(elem);
        return this;
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<E> it;
            {
                this.it = SetBuilder.this.underlyingSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public E next() {
                return (Comparable)this.it.next();
            }
        };
    }
}

