/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Pair;
import de.scravy.bedrock.Seq;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

interface SequenceMethods<Predicate, BiPredicate, Sequence extends SequenceMethods<Predicate, BiPredicate, Sequence>> {
    public static final Comparator<Object> NULL_ACCEPTING_COMPARATOR = (left, right) -> {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return ((Comparable)left).compareTo(right);
    };

    @Nonnegative
    public int length();

    @Nonnull
    public Sequence shuffled(@Nonnull Random var1);

    @Nonnull
    public Sequence reversed();

    @Nonnull
    public Sequence sorted();

    @Nonnull
    public Sequence trimmedToSize();

    @Nonnull
    public Sequence subSequence(@Nonnegative int var1, @Nonnegative int var2);

    @Nonnull
    public Sequence subSequenceView(@Nonnegative int var1, @Nonnegative int var2);

    @Nonnegative
    default public int size() {
        return this.length();
    }

    default public boolean startsWith(@Nonnull Sequence sequence) {
        return this.takeView(sequence.length()).equals(sequence);
    }

    default public boolean endsWith(@Nonnull Sequence sequence) {
        return this.takeRightView(sequence.length()).equals(sequence);
    }

    @Nonnull
    default public Sequence shuffled() {
        return this.shuffled(ThreadLocalRandom.current());
    }

    @Nonnull
    default public Sequence init() {
        return this.subSequence(0, this.length() - 1);
    }

    @Nonnull
    default public Sequence initView() {
        return this.subSequenceView(0, this.length() - 1);
    }

    @Nonnull
    public Seq<Sequence> inits();

    @Nonnull
    public Seq<Sequence> initsView();

    @Nonnull
    default public Sequence tail() {
        return this.subSequence(1, this.length());
    }

    @Nonnull
    default public Sequence tailView() {
        return this.subSequenceView(1, this.length());
    }

    @Nonnull
    public Seq<Sequence> tails();

    @Nonnull
    public Seq<Sequence> tailsView();

    @Nonnull
    default public Sequence take(@Nonnegative int length) {
        return this.subSequence(0, length);
    }

    @Nonnull
    default public Sequence takeView(@Nonnegative int length) {
        return this.subSequenceView(0, length);
    }

    @Nonnull
    default public Sequence takeRight(@Nonnegative int length) {
        return this.subSequence(this.length() - length, this.length());
    }

    @Nonnull
    default public Sequence takeRightView(@Nonnegative int length) {
        return this.subSequenceView(this.length() - length, this.length());
    }

    @Nonnull
    default public Sequence drop(@Nonnegative int length) {
        return this.subSequence(length, this.length());
    }

    @Nonnull
    default public Sequence dropView(@Nonnegative int length) {
        return this.subSequenceView(length, this.length());
    }

    @Nonnull
    default public Sequence dropRight(@Nonnegative int length) {
        return this.subSequence(0, this.length() - length);
    }

    @Nonnull
    default public Sequence dropRightView(@Nonnegative int length) {
        return this.subSequenceView(0, this.length() - length);
    }

    @Nonnull
    public Sequence rotated(int var1);

    @Nonnull
    public Iterator<Sequence> permutationsIterator();

    @Nonnull
    default public Iterable<Sequence> permutationsIterable() {
        return this::permutationsIterator;
    }

    @Nonnull
    default public Stream<Sequence> permutationsStream() {
        return StreamSupport.stream(this.permutationsIterable().spliterator(), false);
    }

    @Nonnull
    public Sequence distinct();

    @Nonnull
    public Sequence takeWhile(@Nonnull Predicate var1);

    @Nonnull
    public Sequence takeWhileView(@Nonnull Predicate var1);

    @Nonnull
    public Sequence dropWhile(@Nonnull Predicate var1);

    @Nonnull
    public Sequence dropWhileView(@Nonnull Predicate var1);

    @Nonnull
    public Sequence filter(@Nonnull Predicate var1);

    @Nonnull
    public Sequence filterNot(@Nonnull Predicate var1);

    @Nonnull
    public Pair<Sequence, Sequence> breakBy(@Nonnull Predicate var1);

    @Nonnull
    public Pair<Sequence, Sequence> breakByView(@Nonnull Predicate var1);

    @Nonnull
    public Pair<Sequence, Sequence> spanBy(@Nonnull Predicate var1);

    @Nonnull
    public Pair<Sequence, Sequence> spanByView(@Nonnull Predicate var1);

    @Nonnull
    public Pair<Sequence, Sequence> partitionBy(@Nonnull Predicate var1);

    @Nonnull
    public Seq<Sequence> group();

    @Nonnull
    public Seq<Sequence> groupBy(@Nonnull BiPredicate var1);

    @Nonnull
    public Seq<Sequence> permutations();
}

