/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqReversed;
import de.scravy.bedrock.SeqSimpleSorted;
import de.scravy.bedrock.SeqSimpleView;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

class SeqReversedView<E>
extends Seq<E> {
    private final int beginOffset;
    private final int endOffset;
    private final Object[] backingArray;

    SeqReversedView(@Nonnull Object[] array, @Nonnegative int beginOffset, @Nonnegative int endOffset) {
        this.backingArray = array;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    @Override
    public E get(@Nonnegative int index) {
        this.checkBounds(index);
        return (E)this.backingArray[this.beginOffset + this.length() - index - 1];
    }

    @Override
    @Nonnull
    public Seq<E> reversed() {
        return new SeqSimpleView(this.backingArray, this.beginOffset, this.endOffset);
    }

    @Override
    @Nonnull
    public Seq<E> sorted() {
        int len = this.length();
        Object[] array = new Object[len];
        System.arraycopy(this.backingArray, this.beginOffset, array, 0, len);
        Arrays.sort(array, NULL_ACCEPTING_COMPARATOR);
        return new SeqSimpleSorted(array);
    }

    @Override
    @Nonnull
    public Seq<E> sortedBy(@Nonnull Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator);
        int len = this.length();
        Object[] array = new Object[len];
        System.arraycopy(this.backingArray, this.beginOffset, array, 0, len);
        Arrays.sort(array, comparator);
        return Seq.ofArrayZeroCopyInternal(array);
    }

    @Override
    @Nonnull
    public Seq<E> trimmedToSize() {
        int len = this.length();
        Object[] array = new Object[len];
        System.arraycopy(this.backingArray, this.beginOffset, array, 0, len);
        return new SeqReversed(array);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        Object[] array = new Object[this.length()];
        int i = 0;
        for (Object e : this) {
            array[i++] = e;
        }
        return array;
    }

    @Override
    @Nonnull
    public Seq<E> subSequence(@Nonnegative int beginOffset, @Nonnegative int endOffset) {
        int begin = Math.max(0, beginOffset);
        int end = Math.min(this.length(), endOffset);
        int len = end - begin;
        if (len <= 0) {
            return SeqReversedView.empty();
        }
        Object[] array = new Object[len];
        System.arraycopy(this.backingArray, this.beginOffset + this.length() - end, array, 0, len);
        return new SeqReversed(array);
    }

    @Override
    @Nonnull
    public Seq<E> subSequenceView(@Nonnegative int beginOffset, @Nonnegative int endOffset) {
        int begin = Math.max(0, beginOffset);
        int end = Math.min(this.length(), endOffset);
        int len = end - begin;
        if (len <= 0) {
            return SeqReversedView.empty();
        }
        return new SeqReversedView<E>(this.backingArray, this.beginOffset + this.length() - end, this.beginOffset + this.length() - begin);
    }

    @Override
    @Nonnull
    public E[] toArray(@Nonnull Class<E> evidence) {
        Objects.requireNonNull(evidence);
        Object[] array = (Object[])Array.newInstance(evidence, this.length());
        int i = 0;
        for (Object e : this) {
            array[i++] = e;
        }
        return array;
    }

    @Override
    @Nonnegative
    public int length() {
        return this.endOffset - this.beginOffset;
    }
}

