/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.AbstractBuilder;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqSimple;
import de.scravy.bedrock.SeqSimpleSorted;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class SeqBuilder<E>
extends AbstractBuilder<E, Seq<E>, SeqBuilder<E>> {
    private final ArrayList<E> arrayList;

    public SeqBuilder() {
        this.arrayList = new ArrayList();
    }

    public SeqBuilder(int sizeHint) {
        this.arrayList = new ArrayList(sizeHint);
    }

    @Override
    @Nonnull
    public SeqBuilder<E> add(E elem) {
        this.arrayList.add(elem);
        return this;
    }

    @Override
    @Nonnull
    public Seq<E> result() {
        if (this.arrayList.isEmpty()) {
            return Seq.empty();
        }
        Object[] array = this.arrayList.toArray(new Object[0]);
        return new SeqSimple(array);
    }

    @Nonnull
    <F extends Comparable<? super F>> Seq<F> resultSortedInternal() {
        if (this.arrayList.isEmpty()) {
            return Seq.empty();
        }
        Object[] array = this.arrayList.toArray(new Object[0]);
        return new SeqSimpleSorted(array);
    }

    public boolean isEmpty() {
        return this.arrayList.isEmpty();
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    @Nonnegative
    public int size() {
        return this.arrayList.size();
    }

    @Nonnull
    public SeqBuilder<E> clear() {
        this.arrayList.clear();
        return this;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int n;
            private int i;
            {
                this.n = SeqBuilder.this.arrayList.size();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.n;
            }

            @Override
            public E next() {
                return SeqBuilder.this.arrayList.get(this.i++);
            }
        };
    }
}

