/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Container;
import de.scravy.bedrock.EmptyIteratorException;
import de.scravy.bedrock.ExtendedIterable;
import java.util.AbstractQueue;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class RingBuffer<E>
extends AbstractQueue<E>
implements ExtendedIterable<E>,
Container<E> {
    @Nonnull
    private final E[] underlying;
    @Nonnegative
    private int upper = 0;
    @Nonnegative
    private int lower = 0;
    @Nonnegative
    private int size = 0;

    public RingBuffer(@Nonnegative int capacity) {
        this.underlying = new Object[capacity];
    }

    @Override
    @Nonnull
    public Stream<E> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.size(), 0), false);
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final int startedLower;
            private final int startedUpper;
            private int current;
            private final int endAt;
            {
                this.startedLower = RingBuffer.this.lower;
                this.startedUpper = RingBuffer.this.upper;
                this.current = 0;
                this.endAt = RingBuffer.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.current < this.endAt;
            }

            @Override
            public E next() {
                if (RingBuffer.this.lower != this.startedLower || RingBuffer.this.upper != this.startedUpper) {
                    throw new ConcurrentModificationException();
                }
                if (!this.hasNext()) {
                    throw new EmptyIteratorException();
                }
                Object e = RingBuffer.this.underlying[(this.startedLower + this.current) % RingBuffer.this.capacity()];
                ++this.current;
                return e;
            }
        };
    }

    @Override
    @Nonnegative
    public int size() {
        return this.size;
    }

    @Nonnegative
    public int capacity() {
        return this.underlying.length;
    }

    @Override
    public boolean offer(E e) {
        if (this.size() >= this.capacity()) {
            return false;
        }
        this.underlying[this.upper] = e;
        ++this.size;
        this.upper = this.next(this.upper);
        return true;
    }

    @Override
    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        E e = this.underlying[this.lower];
        --this.size;
        this.lower = this.next(this.lower);
        return e;
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.underlying[this.lower];
    }

    @Nonnegative
    private int next(@Nonnegative int current) {
        return (current + 1) % this.capacity();
    }

    @Override
    public String toString() {
        return this.stream().map(Objects::toString).collect(Collectors.joining(",", "[", "]"));
    }
}

