/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.ForEach;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqBuilder;
import de.scravy.bedrock.SeqSimple;
import de.scravy.bedrock.Set;
import de.scravy.bedrock.SetBuilder;
import de.scravy.bedrock.ThrowingBiFunction;
import de.scravy.bedrock.ThrowingFunction;
import de.scravy.bedrock.Try;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class Reflections {
    private static final Map<Class<?>, Class<?>> boxedToPrimitiveClassesMap = new HashMap();
    private static final Map<Class<?>, Class<?>> primitiveToBoxedClassesMap;

    @Nonnull
    public static <S, T> Optional<ThrowingFunction<S, T>> getFactoryConstructor(@Nonnull Class<S> from, @Nonnull Class<T> clazz) {
        Objects.requireNonNull(from, "'from' must not be null");
        Objects.requireNonNull(clazz, "'clazz' must not be null");
        return Arrays.stream(clazz.getConstructors()).filter(constructor -> Modifier.isPublic(constructor.getModifiers())).filter(constructor -> constructor.getParameterCount() == 1).filter(constructor -> constructor.getParameterTypes()[0].isAssignableFrom(from)).findFirst().map(constructor -> s -> constructor.newInstance(s));
    }

    @Nonnull
    public static <S, T> Optional<ThrowingFunction<S, T>> getFactoryMethod(@Nonnull Class<S> from, @Nonnull Class<T> clazz) {
        Objects.requireNonNull(from, "'from' must not be null");
        Objects.requireNonNull(clazz, "'clazz' must not be null");
        return Arrays.stream(clazz.getMethods()).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> method.getParameterCount() == 1).filter(method -> method.getReturnType().equals(clazz)).filter(method -> method.getParameterTypes()[0].isAssignableFrom(from)).findFirst().map(method -> s -> method.invoke(null, s));
    }

    @Nonnull
    public static <S, T> Optional<ThrowingFunction<S, T>> getFactory(@Nonnull Class<S> from, @Nonnull Class<T> clazz) {
        Objects.requireNonNull(from, "'from' must not be null");
        Objects.requireNonNull(clazz, "'clazz' must not be null");
        Optional<ThrowingFunction<S, Object>> factory = Reflections.getFactoryConstructor(from, clazz);
        if (factory.isPresent()) {
            return factory;
        }
        factory = Reflections.getFactoryMethod(from, clazz);
        if (factory.isPresent()) {
            return factory;
        }
        Class<?> boxedClass = Reflections.getBoxedClassFor(clazz);
        if (boxedClass != clazz) {
            Optional<ThrowingFunction<S, ThrowingFunction<S, T>>> factory2;
            Optional<ThrowingFunction<S, ThrowingFunction<S, T>>> theFactory = factory2 = Reflections.getFactory(from, boxedClass);
            return theFactory;
        }
        return Optional.empty();
    }

    @Nonnull
    public static <T> Optional<Callable<T>> getFactory(@Nonnull Class<T> clazz) {
        Objects.requireNonNull(clazz, "'clazz' must not be null");
        return Arrays.stream(clazz.getConstructors()).filter(constructor -> Modifier.isPublic(constructor.getModifiers())).filter(constructor -> constructor.getParameterCount() == 0).findFirst().map(constructor -> () -> constructor.newInstance(new Object[0]));
    }

    public static <T> T proxy(@Nonnull Class<T> clazz, @Nonnull ThrowingBiFunction<String, Seq<Object>, Object> handler) {
        Objects.requireNonNull(clazz, "'clazz' must not be null");
        Objects.requireNonNull(handler, "'handler' must not be null");
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (proxy, method, args) -> handler.apply(method.getName(), new SeqSimple(args)));
    }

    public static Class<?> getPrimitiveClassFor(Class<?> boxedClass) {
        return boxedToPrimitiveClassesMap.getOrDefault(boxedClass, boxedClass);
    }

    public static Class<?> getBoxedClassFor(Class<?> primitiveClass) {
        return primitiveToBoxedClassesMap.getOrDefault(primitiveClass, primitiveClass);
    }

    public static Seq<Class<?>> getParents(Class<?> clazz) {
        Class<?> current = clazz;
        SeqBuilder seqBuilder = Seq.builder();
        do {
            seqBuilder.add(current);
        } while (!Object.class.equals(current = current.getSuperclass()) && current != null);
        if (current != null) {
            seqBuilder.add(current);
        }
        return (Seq)seqBuilder.result().reversed();
    }

    @Nonnull
    public static Optional<Class<?>> getCommonBaseClass(@Nonnull Class<?> oneClass, @Nonnull Class<?> anotherClass) {
        Objects.requireNonNull(oneClass);
        Objects.requireNonNull(anotherClass);
        Seq<Class<?>> commonAncestors = Seq.commonPrefixView(Reflections.getParents(oneClass), Reflections.getParents(anotherClass));
        return commonAncestors.lastOptional();
    }

    @Nonnull
    public static <T> Set<Property<T>> getProperties(@Nonnull Class<T> clazz) {
        Objects.requireNonNull(clazz);
        SetBuilder builder = Set.builder();
        try {
            ForEach.forEach(Introspector.getBeanInfo(clazz).getPropertyDescriptors(), propertyDescriptor -> builder.add(new Property(propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod())));
        }
        catch (IntrospectionException exc) {
            throw new RuntimeException("could not get property descriptors using BeanInfo Introspector", exc);
        }
        return builder.result();
    }

    @Generated
    private Reflections() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        boxedToPrimitiveClassesMap.put(Void.class, Void.TYPE);
        boxedToPrimitiveClassesMap.put(Boolean.class, Boolean.TYPE);
        boxedToPrimitiveClassesMap.put(Character.class, Character.TYPE);
        boxedToPrimitiveClassesMap.put(Byte.class, Byte.TYPE);
        boxedToPrimitiveClassesMap.put(Short.class, Short.TYPE);
        boxedToPrimitiveClassesMap.put(Integer.class, Integer.TYPE);
        boxedToPrimitiveClassesMap.put(Long.class, Long.TYPE);
        boxedToPrimitiveClassesMap.put(Float.class, Float.TYPE);
        boxedToPrimitiveClassesMap.put(Double.class, Double.TYPE);
        primitiveToBoxedClassesMap = new HashMap();
        primitiveToBoxedClassesMap.put(Void.TYPE, Void.class);
        primitiveToBoxedClassesMap.put(Boolean.TYPE, Boolean.class);
        primitiveToBoxedClassesMap.put(Character.TYPE, Character.class);
        primitiveToBoxedClassesMap.put(Byte.TYPE, Byte.class);
        primitiveToBoxedClassesMap.put(Short.TYPE, Short.class);
        primitiveToBoxedClassesMap.put(Integer.TYPE, Integer.class);
        primitiveToBoxedClassesMap.put(Long.TYPE, Long.class);
        primitiveToBoxedClassesMap.put(Float.TYPE, Float.class);
        primitiveToBoxedClassesMap.put(Double.TYPE, Double.class);
    }

    public static final class Property<T>
    implements Comparable<Property> {
        private final String name;
        private final Class<?> type;
        private final Method getter;
        private final Method setter;

        public Object get(T instance) {
            try {
                return this.getter.invoke(instance, new Object[0]);
            }
            catch (Exception exc) {
                throw new RuntimeException("could not invoke getter for " + this.name + " on " + instance, exc);
            }
        }

        public void set(T instance, Object value) {
            if (this.setter == null) {
                return;
            }
            try {
                if (value == null) {
                    this.setter.invoke(instance, new Object[]{null});
                } else if (this.type.isAssignableFrom(value.getClass())) {
                    this.setter.invoke(instance, value);
                } else {
                    Optional<ThrowingFunction<?, ?>> maybeFactory = Reflections.getFactory(value.getClass(), this.type);
                    Object finalValue = Try.fromOptional(maybeFactory).map(f -> f.apply(value)).orElseThrowRuntime();
                    this.setter.invoke(instance, finalValue);
                }
            }
            catch (Exception exc) {
                throw new RuntimeException("could not invoke setter for " + this.name + " and " + value + " on " + instance, exc);
            }
        }

        @Override
        public int compareTo(Property property) {
            return this.name.compareTo(property.name);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public Method getGetter() {
            return this.getter;
        }

        @Generated
        public Method getSetter() {
            return this.setter;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Method this$getter = this.getGetter();
            Method other$getter = other.getGetter();
            if (this$getter == null ? other$getter != null : !((Object)this$getter).equals(other$getter)) {
                return false;
            }
            Method this$setter = this.getSetter();
            Method other$setter = other.getSetter();
            return !(this$setter == null ? other$setter != null : !((Object)this$setter).equals(other$setter));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Method $getter = this.getGetter();
            result = result * 59 + ($getter == null ? 43 : ((Object)$getter).hashCode());
            Method $setter = this.getSetter();
            result = result * 59 + ($setter == null ? 43 : ((Object)$setter).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Reflections.Property(name=" + this.getName() + ", type=" + this.getType() + ", getter=" + this.getGetter() + ", setter=" + this.getSetter() + ")";
        }

        @Generated
        Property(String name, Class<?> type, Method getter, Method setter) {
            this.name = name;
            this.type = type;
            this.getter = getter;
            this.setter = setter;
        }
    }
}

