/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqSimple;
import java.util.Iterator;
import javax.annotation.Nonnull;

final class PermutationIterator<E>
implements Iterator<Seq<E>> {
    private final Seq<E> source;
    private final int[] indices;
    private final int[] directions;
    private Seq<E> upcoming;

    PermutationIterator(@Nonnull Seq<E> source) {
        this.source = source;
        this.indices = new int[source.length()];
        this.directions = new int[source.length()];
        for (int i = 1; i < source.length(); ++i) {
            this.indices[i] = i;
            this.directions[i] = -1;
        }
        this.upcoming = source;
    }

    private void swap(int i, int j) {
        int tmp = this.indices[i];
        this.indices[i] = this.indices[j];
        this.indices[j] = tmp;
        tmp = this.directions[i];
        this.directions[i] = this.directions[j];
        this.directions[j] = tmp;
    }

    private Seq<E> makeResult() {
        Object[] array = new Object[this.source.length()];
        for (int i = 0; i < this.source.length(); ++i) {
            array[i] = this.source.get(this.indices[i]);
        }
        return new SeqSimple(array);
    }

    @Override
    public boolean hasNext() {
        return this.upcoming != null;
    }

    private int findMaxIndex() {
        for (int i = 0; i < this.source.length(); ++i) {
            if (this.directions[i] == 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    @Nonnull
    public Seq<E> next() {
        int maxIndex = this.findMaxIndex();
        Seq<E> result = this.upcoming;
        if (maxIndex == -1) {
            this.upcoming = null;
        } else {
            for (int i = maxIndex + 1; i < this.source.length(); ++i) {
                if (this.directions[i] == 0 || this.indices[i] <= this.indices[maxIndex]) continue;
                maxIndex = i;
            }
            int moveTo = maxIndex + this.directions[maxIndex];
            this.swap(maxIndex, moveTo);
            if (moveTo == 0 || moveTo == this.source.length() - 1 || this.indices[moveTo + this.directions[moveTo]] > this.indices[moveTo]) {
                this.directions[moveTo] = 0;
            }
            for (int i = 0; i < this.source.length(); ++i) {
                if (this.indices[i] <= this.indices[moveTo]) continue;
                this.directions[i] = i < moveTo ? 1 : -1;
            }
            this.upcoming = this.makeResult();
        }
        return result;
    }
}

