/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.ArrayMap;
import de.scravy.bedrock.CharParser;
import de.scravy.bedrock.Container;
import de.scravy.bedrock.Functions;
import de.scravy.bedrock.Mapping;
import de.scravy.bedrock.Parser;
import de.scravy.bedrock.Seq;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class Parsers {
    public static JsonParser jsonParser() {
        return new JsonParser();
    }

    @Generated
    private Parsers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class JsonParser
    implements SimpleParser<String, Object> {
        private final CharParser<Object> value;

        JsonParser() {
            CharParser<Character> delimiter = CharParser.character(':');
            CharParser<Void> whitespace = CharParser.skipMany(CharParser.anyOf(" \t\r\n"));
            CharParser<Character> digit = CharParser.range('0', '9');
            CharParser<Character> nonZeroDigit = CharParser.range('1', '9');
            CharParser hexDigit = CharParser.oneOf(digit, CharParser.range('a', 'z'), CharParser.range('A', 'Z'));
            CharParser bool = CharParser.oneOf(CharParser.string("true").map(Functions.constant(true)), CharParser.string("false").map(Functions.constant(false)));
            CharParser<Object> nothing = CharParser.string("null").map(Functions.constant(null));
            CharParser<String> string = CharParser.between(CharParser.character('\"'), CharParser.many(CharParser.choice(CharParser.noneOf("\"\\"), CharParser.right(CharParser.character('\\'), CharParser.choice(CharParser.anyOf("\"\\/bfnrt").map(d -> {
                switch (d.charValue()) {
                    case '\"': {
                        return Character.valueOf('\"');
                    }
                    case '\\': {
                        return Character.valueOf('\\');
                    }
                    case '/': {
                        return Character.valueOf('/');
                    }
                    case 'b': {
                        return Character.valueOf('\b');
                    }
                    case 'f': {
                        return Character.valueOf('\f');
                    }
                    case 'n': {
                        return Character.valueOf('\n');
                    }
                    case 'r': {
                        return Character.valueOf('\r');
                    }
                    case 't': {
                        return Character.valueOf('\t');
                    }
                }
                throw new RuntimeException("really never can happen");
            }), CharParser.right(CharParser.character('u'), CharParser.times(4, hexDigit)).map(ds -> Character.valueOf((char)Integer.parseInt(ds.asString(), 16))))))).map(Container::asString), CharParser.character('\"'));
            CharParser<BigDecimal> number = CharParser.seq(CharParser.option(BigDecimal.ONE, CharParser.character('-').map(Functions.constant(BigDecimal.ONE.negate()))), CharParser.choice(CharParser.character('0').map(xva$0 -> Seq.of(xva$0)), CharParser.seq(nonZeroDigit, CharParser.many(digit)).map(p -> Seq.concat(Seq.of((Character)p.fst()), (Seq)p.snd()))).map(Container::asString), CharParser.option("", CharParser.right(CharParser.character('.'), CharParser.many1(digit)).map(Container::asString)), CharParser.option("", CharParser.seq(CharParser.anyOf("eE"), CharParser.option(Character.valueOf('+'), CharParser.anyOf("-+")), CharParser.many1(digit)).map(p -> Seq.concat(Seq.of((Character)p.getFirst(), (Character)p.getSecond()), (Seq)p.getThird()).asString()))).map(p -> ((BigDecimal)p.getFirst()).multiply(new BigDecimal((String)p.getSecond() + (String)p.getThird() + (String)p.getFourth())));
            CharParser<String> key = CharParser.between(whitespace, string, whitespace);
            CharParser object = CharParser.between(CharParser.character('{'), CharParser.choice(CharParser.sepBy(CharParser.seq(key, CharParser.right(delimiter, this.value())), CharParser.character(',')).map(ArrayMap::ofSeq), whitespace.map(Functions.constant(Mapping.empty()))), CharParser.character('}'));
            CharParser array = CharParser.between(CharParser.character('['), CharParser.choice(CharParser.sepBy(this.value(), CharParser.character(',')), whitespace.map(Functions.constant(Seq.empty()))), CharParser.character(']'));
            this.value = CharParser.between(whitespace, CharParser.oneOf(object, array, string, number, bool, nothing), whitespace);
        }

        final CharParser<Object> value() {
            return CharParser.recursive(() -> this.value);
        }

        @Override
        public final Object parse(@Nonnull String string) throws NoParseException {
            CharParser.Result<Object> result = this.value().parse(string);
            if (!result.isSuccess()) {
                throw new NoParseException(result);
            }
            return result.getValue();
        }
    }

    public static interface SimpleParser<Source, Target> {
        public Target parse(@Nonnull Source var1) throws NoParseException;
    }

    public static class NoParseException
    extends Exception {
        public NoParseException(CharParser.Result result) {
            super(result.getRemaining().asString());
        }

        public NoParseException(Parser.Result result) {
            super(result.getRemaining().toString());
        }
    }
}

