/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Control;
import de.scravy.bedrock.Either;
import de.scravy.bedrock.Function0;
import de.scravy.bedrock.Mapping;
import de.scravy.bedrock.Pair;
import de.scravy.bedrock.Quadruple;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqBuilder;
import de.scravy.bedrock.Triple;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;

@FunctionalInterface
public interface Parser<T> {
    public Result<T> parse(Seq<?> var1);

    default public <U> Parser<U> map(Function<T, U> f) {
        return seq -> this.parse(seq).map(f);
    }

    public static <T, U> Parser<T> left(Parser<T> p1, Parser<U> p2) {
        return seq -> {
            Result r1 = p1.parse(seq);
            if (r1.isSuccess()) {
                Result r2 = p2.parse(r1.getRemaining());
                if (r2.isSuccess()) {
                    return new Result.Success(r1.getValue(), r2.getRemaining());
                }
                return r2.withRemaining(seq).as();
            }
            return r1.withRemaining(seq);
        };
    }

    public static <T, U> Parser<U> right(Parser<T> p1, Parser<U> p2) {
        return seq -> {
            Result r1 = p1.parse(seq);
            if (r1.isSuccess()) {
                Result r2 = p2.parse(r1.getRemaining());
                if (r2.isSuccess()) {
                    return r2;
                }
                return r2.withRemaining(seq);
            }
            return r1.withRemaining(seq).as();
        };
    }

    public static <S, T extends S, U extends S> Parser<S> choice(Parser<T> p1, Parser<U> p2) {
        return seq -> {
            Result r1 = p1.parse(seq);
            if (r1.isSuccess()) {
                return r1.as();
            }
            return p2.parse(seq).as();
        };
    }

    public static <T, U> Parser<Either<T, U>> either(Parser<T> p1, Parser<U> p2) {
        return seq -> {
            Result<Either> r1 = p1.parse(seq).map(Either::left);
            if (r1.isSuccess()) {
                return r1;
            }
            return p2.parse(seq).map(Either::right);
        };
    }

    @SafeVarargs
    public static <T> Parser<T> oneOf(Parser<? extends T> ... ps) {
        return seq -> {
            for (Parser p : ps) {
                Result result = p.parse(seq);
                if (!result.isSuccess()) continue;
                return result.as();
            }
            return new Result.NoParse(seq);
        };
    }

    public static <T> Parser<T> satisfies(Class<T> clazz, Predicate<T> predicate) {
        return seq -> {
            Object t;
            Object obj;
            if (seq.nonEmpty() && clazz.isAssignableFrom((obj = seq.head()).getClass()) && predicate.test(t = obj)) {
                return new Result.Success(t, (Seq)seq.tailView());
            }
            return new Result.NoParse(seq);
        };
    }

    public static <T, U> Parser<U> satisfies2(Class<T> clazz, Function<T, Optional<U>> f) {
        return seq -> {
            Object t;
            Optional result;
            Object obj;
            if (seq.nonEmpty() && clazz.isAssignableFrom((obj = seq.head()).getClass()) && (result = (Optional)f.apply(t = obj)).isPresent()) {
                return new Result.Success(result.get(), (Seq)seq.tailView());
            }
            return new Result.NoParse(seq);
        };
    }

    public static <T, U> Parser<U> recurse(Class<T> clazz, Predicate<T> predicate, Function<T, Seq<?>> extractor, Parser<U> parser) {
        return seq -> {
            Object t;
            Object obj;
            if (seq.nonEmpty() && clazz.isAssignableFrom((obj = seq.head()).getClass()) && predicate.test(t = obj)) {
                Seq rseq = (Seq)extractor.apply(t);
                Result result = parser.parse(rseq);
                if (result.isSuccess()) {
                    if (result.getRemaining().nonEmpty()) {
                        return new Result.NoParse(seq);
                    }
                    return result.withRemaining((Seq)seq.tailView());
                }
                return result.withRemaining(seq);
            }
            return new Result.NoParse(seq);
        };
    }

    public static <T, U> Parser<U> recurse2(Class<T> clazz, Function<T, Seq<?>> extractor, Function<T, Parser<U>> parser) {
        return seq -> {
            Object obj;
            if (seq.nonEmpty() && clazz.isAssignableFrom((obj = seq.head()).getClass())) {
                Object t = obj;
                Seq rseq = (Seq)extractor.apply(t);
                Result result = ((Parser)parser.apply(t)).parse(rseq);
                if (result.isSuccess()) {
                    if (result.getRemaining().nonEmpty()) {
                        return new Result.NoParse(seq);
                    }
                    return result.withRemaining((Seq)seq.tailView());
                }
                return result.withRemaining(seq);
            }
            return new Result.NoParse(seq);
        };
    }

    public static <T> Parser<Optional<T>> optional(Parser<T> parser) {
        return seq -> {
            Result result = parser.parse(seq);
            if (result.isNoParse()) {
                return new Result.Success(Optional.empty(), result.getRemaining());
            }
            return result.map(Optional::of);
        };
    }

    public static <T> Parser<T> option(T fallback, Parser<T> parser) {
        return Parser.optional(parser).map(optional -> optional.orElse(fallback));
    }

    public static <T> Parser<T> option(Supplier<T> fallbackSupplier, Parser<T> parser) {
        return Parser.optional(parser).map(optional -> optional.orElseGet(fallbackSupplier));
    }

    @SafeVarargs
    public static <T> Parser<Seq<T>> sequence(Parser<T> ... ps) {
        return seq -> {
            SeqBuilder seqBuilder = Seq.builder();
            Seq<?> remaining = seq;
            for (Parser p : ps) {
                if (remaining.isEmpty()) {
                    return new Result.NoParse(seq);
                }
                Result result = p.parse(remaining);
                if (!result.isSuccess()) {
                    return result.withRemaining(seq).as();
                }
                remaining = result.getRemaining();
                seqBuilder.add(result.getValue());
            }
            return new Result.Success<Object>(seqBuilder.result(), remaining);
        };
    }

    public static <T> Parser<Seq<T>> sequence(Iterable<Parser<T>> ps) {
        return seq -> {
            SeqBuilder seqBuilder = Seq.builder();
            Seq<?> remaining = seq;
            for (Parser p : ps) {
                if (remaining.isEmpty()) {
                    return new Result.NoParse(seq);
                }
                Result result = p.parse(remaining);
                if (!result.isSuccess()) {
                    return result.withRemaining(seq).as();
                }
                remaining = result.getRemaining();
                seqBuilder.add(result.getValue());
            }
            return new Result.Success<Object>(seqBuilder.result(), remaining);
        };
    }

    public static <T> Parser<Seq<T>> times(int n, Parser<T> p) {
        return seq -> {
            SeqBuilder seqBuilder = Seq.builder();
            Seq<?> remaining = seq;
            for (int i = 0; i < n; ++i) {
                if (remaining.isEmpty()) {
                    return new Result.NoParse(seq);
                }
                Result result = p.parse(remaining);
                if (!result.isSuccess()) {
                    return result.withRemaining(seq).as();
                }
                remaining = result.getRemaining();
                seqBuilder.add(result.getValue());
            }
            return new Result.Success<Object>(seqBuilder.result(), remaining);
        };
    }

    public static <T, U> Parser<Pair<T, U>> seq(Parser<T> p1, Parser<U> p2) {
        return seq -> {
            Result r1 = p1.parse(seq);
            if (r1.isSuccess()) {
                Result r2 = p2.parse(r1.getRemaining());
                if (r2.isSuccess()) {
                    return new Result.Success(Pair.of(r1.getValue(), r2.getValue()), r2.getRemaining());
                }
                return r2.withRemaining(seq).as();
            }
            return r1.withRemaining(seq).as();
        };
    }

    public static <T, U, V> Parser<Triple<T, U, V>> seq(Parser<T> p1, Parser<U> p2, Parser<V> p3) {
        return seq -> {
            Result r1 = p1.parse(seq);
            if (r1.isSuccess()) {
                Result r2 = p2.parse(r1.getRemaining());
                if (r2.isSuccess()) {
                    Result r3 = p3.parse(r2.getRemaining());
                    if (r3.isSuccess()) {
                        return new Result.Success(Triple.of(r1.getValue(), r2.getValue(), r3.getValue()), r3.getRemaining());
                    }
                    return r3.withRemaining(seq).as();
                }
                return r2.withRemaining(seq).as();
            }
            return r1.withRemaining(seq).as();
        };
    }

    public static <T, U, V, W> Parser<Quadruple<T, U, V, W>> seq(Parser<T> p1, Parser<U> p2, Parser<V> p3, Parser<W> p4) {
        return seq -> {
            Result r1 = p1.parse(seq);
            if (r1.isSuccess()) {
                Result r2 = p2.parse(r1.getRemaining());
                if (r2.isSuccess()) {
                    Result r3 = p3.parse(r2.getRemaining());
                    if (r3.isSuccess()) {
                        Result r4 = p4.parse(r3.getRemaining());
                        if (r4.isSuccess()) {
                            return new Result.Success(Quadruple.of(r1.getValue(), r2.getValue(), r3.getValue(), r4.getValue()), r4.getRemaining());
                        }
                        return r4.withRemaining(seq).as();
                    }
                    return r3.withRemaining(seq).as();
                }
                return r2.withRemaining(seq).as();
            }
            return r1.withRemaining(seq).as();
        };
    }

    public static <T> Parser<Seq<T>> many(Parser<T> parser) {
        return seq -> {
            SeqBuilder resultBuilder = Seq.builder();
            Seq<?> remaining = seq;
            while (remaining.nonEmpty()) {
                Result result = parser.parse(remaining);
                if (!result.isSuccess()) {
                    return new Result.Success<Object>(resultBuilder.result(), remaining);
                }
                resultBuilder.add(result.getValue());
                remaining = result.getRemaining();
            }
            return new Result.Success<Object>(resultBuilder.result(), remaining);
        };
    }

    public static <T> Parser<Seq<T>> many1(Parser<T> parser) {
        Parser manyParser = Parser.many(parser);
        return seq -> {
            Result result = manyParser.parse(seq);
            if (result.isSuccess() && ((Seq)result.getValue()).isEmpty()) {
                return new Result.NoParse(seq);
            }
            return result;
        };
    }

    public static <T> Parser<Void> skipMany(Parser<T> parser) {
        return seq -> {
            Seq<?> remaining = seq;
            while (remaining.nonEmpty()) {
                Result result = parser.parse(remaining);
                if (!result.isSuccess()) {
                    return new Result.Success<Object>(null, remaining);
                }
                remaining = result.getRemaining();
            }
            return new Result.Success<Object>(null, remaining);
        };
    }

    public static <T, U> Parser<Seq<T>> sepBy(Parser<T> parser, Parser<U> sep) {
        Parser p = Parser.right(sep, parser);
        return seq -> {
            SeqBuilder resultBuilder = Seq.builder();
            Seq<?> remaining = seq;
            Result result = parser.parse(remaining);
            if (result.isSuccess()) {
                resultBuilder.add(result.getValue());
                remaining = result.getRemaining();
                while (remaining.nonEmpty()) {
                    result = p.parse(remaining);
                    if (!result.isSuccess()) {
                        return new Result.Success<Object>(resultBuilder.result(), remaining);
                    }
                    resultBuilder.add(result.getValue());
                    remaining = result.getRemaining();
                }
            }
            return new Result.Success<Object>(resultBuilder.result(), remaining);
        };
    }

    public static <T, U> Parser<Seq<T>> sepBy1(Parser<T> parser, Parser<U> sep) {
        Parser sepByParser = Parser.sepBy(parser, sep);
        return seq -> {
            Result result = sepByParser.parse(seq);
            if (result.isSuccess() && ((Seq)result.getValue()).isEmpty()) {
                return new Result.NoParse(seq);
            }
            return result;
        };
    }

    public static <T> Parser<T> recursive(Supplier<Parser<T>> supplier) {
        Function0 parserSupplier = Control.memoizing(supplier);
        return seq -> ((Parser)parserSupplier.get()).parse(seq);
    }

    public static <T> boolean shuntingYard(Iterable<T> in, Consumer<T> out, Mapping<T, Integer> precedenceMap, Predicate<T> isLeftAssociative, Predicate<T> isLeftBracket, Predicate<T> isRightBracket) {
        return Parser.shuntingYard(in, out, precedenceMap.keys()::contains, (a, b) -> (Integer)precedenceMap.apply((Object)a) > (Integer)precedenceMap.apply((Object)b), (a, b) -> ((Integer)precedenceMap.apply((Object)a)).equals(precedenceMap.apply((Object)b)), isLeftAssociative, isLeftBracket, isRightBracket);
    }

    public static <T> boolean shuntingYard(Iterable<T> in, Consumer<T> out, Predicate<T> isOperator, BiPredicate<T, T> hasHigherPrecedenceThan, BiPredicate<T, T> hasEqualPrecedenceAs, Predicate<T> isLeftAssociative, Predicate<T> isLeftBracket, Predicate<T> isRightBracket) {
        ArrayDeque<T> stack = new ArrayDeque<T>();
        for (T s : in) {
            if (isOperator.test(s)) {
                while (!stack.isEmpty() && isOperator.test(stack.peek()) && (hasHigherPrecedenceThan.test(stack.peek(), s) || hasEqualPrecedenceAs.test(stack.peek(), s) && isLeftAssociative.test(stack.peek()))) {
                    out.accept(stack.pop());
                }
                stack.push(s);
                continue;
            }
            if (isLeftBracket.test(s)) {
                stack.push(s);
                continue;
            }
            if (isRightBracket.test(s)) {
                while (!stack.isEmpty() && !isLeftBracket.test(stack.peek())) {
                    out.accept(stack.pop());
                }
                if (!stack.isEmpty() && isLeftBracket.test(stack.peek())) {
                    stack.pop();
                    continue;
                }
                return false;
            }
            out.accept(s);
        }
        while (!stack.isEmpty()) {
            Object t = stack.pop();
            if (!isOperator.test(t)) {
                return false;
            }
            out.accept(t);
        }
        return true;
    }

    public static abstract class Result<E> {
        public abstract <F> Result<F> map(Function<E, F> var1);

        public abstract Seq<?> getRemaining();

        public abstract Result<E> withRemaining(Seq<?> var1);

        public E getValue() {
            return null;
        }

        public boolean isSuccess() {
            return false;
        }

        public boolean isNoParse() {
            return false;
        }

        <T> Result<T> as() {
            return this;
        }

        @Generated
        Result() {
        }

        public static final class NoParse<E>
        extends Result<E> {
            private final Seq<?> remaining;

            @Override
            public <F> Result<F> map(Function<E, F> f) {
                return this;
            }

            @Override
            public boolean isNoParse() {
                return true;
            }

            @Generated
            public NoParse(Seq<?> remaining) {
                this.remaining = remaining;
            }

            @Override
            @Generated
            public Seq<?> getRemaining() {
                return this.remaining;
            }

            @Generated
            public String toString() {
                return "Parser.Result.NoParse(remaining=" + this.getRemaining() + ")";
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NoParse)) {
                    return false;
                }
                NoParse other = (NoParse)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Seq<?> this$remaining = this.getRemaining();
                Seq<?> other$remaining = other.getRemaining();
                return !(this$remaining == null ? other$remaining != null : !((Object)this$remaining).equals(other$remaining));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NoParse;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Seq<?> $remaining = this.getRemaining();
                result = result * 59 + ($remaining == null ? 43 : ((Object)$remaining).hashCode());
                return result;
            }

            @Override
            @Generated
            public NoParse<E> withRemaining(Seq<?> remaining) {
                return this.remaining == remaining ? this : new NoParse<E>(remaining);
            }
        }

        public static final class Success<E>
        extends Result<E> {
            private final E value;
            private final Seq<?> remaining;

            @Override
            public <F> Result<F> map(Function<E, F> f) {
                return new Success<F>(f.apply(this.value), this.remaining);
            }

            @Override
            public boolean isSuccess() {
                return true;
            }

            @Generated
            public Success(E value, Seq<?> remaining) {
                this.value = value;
                this.remaining = remaining;
            }

            @Override
            @Generated
            public E getValue() {
                return this.value;
            }

            @Override
            @Generated
            public Seq<?> getRemaining() {
                return this.remaining;
            }

            @Generated
            public String toString() {
                return "Parser.Result.Success(value=" + this.getValue() + ", remaining=" + this.getRemaining() + ")";
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Success)) {
                    return false;
                }
                Success other = (Success)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                E this$value = this.getValue();
                E other$value = other.getValue();
                if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                    return false;
                }
                Seq<?> this$remaining = this.getRemaining();
                Seq<?> other$remaining = other.getRemaining();
                return !(this$remaining == null ? other$remaining != null : !((Object)this$remaining).equals(other$remaining));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Success;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                E $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                Seq<?> $remaining = this.getRemaining();
                result = result * 59 + ($remaining == null ? 43 : ((Object)$remaining).hashCode());
                return result;
            }

            @Override
            @Generated
            public Success<E> withRemaining(Seq<?> remaining) {
                return this.remaining == remaining ? this : new Success<E>(this.value, remaining);
            }
        }
    }
}

