/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public final class Operators {
    public static int plus(int a, int b) {
        return a + b;
    }

    @Nonnull
    public static IntUnaryOperator plus(int a) {
        return b -> a + b;
    }

    public static long plus(long a, long b) {
        return a + b;
    }

    @Nonnull
    public static LongUnaryOperator plus(long a) {
        return b -> a + b;
    }

    public static double plus(double a, double b) {
        return a + b;
    }

    @Nonnull
    public static DoubleUnaryOperator plus(double a) {
        return b -> a + b;
    }

    public static Integer plus(@Nullable Integer a, @Nullable Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a + b;
    }

    @Nonnull
    public static UnaryOperator<Integer> plus(@Nullable Integer a) {
        return b -> Operators.plus(a, b);
    }

    public static Long plus(@Nullable Long a, @Nullable Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a + b;
    }

    @Nonnull
    public static UnaryOperator<Long> plus(@Nullable Long a) {
        return b -> Operators.plus(a, b);
    }

    public static Double plus(@Nullable Double a, @Nullable Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a + b;
    }

    @Nonnull
    public static UnaryOperator<Double> plus(@Nullable Double a) {
        return b -> Operators.plus(a, b);
    }

    public static BigInteger plus(@Nullable BigInteger a, @Nullable BigInteger b) {
        if (a == null || b == null) {
            return null;
        }
        return a.add(b);
    }

    @Nonnull
    public static UnaryOperator<BigInteger> plus(@Nullable BigInteger a) {
        return b -> Operators.plus(a, b);
    }

    public static BigDecimal plus(@Nullable BigDecimal a, @Nullable BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        return a.add(b);
    }

    @Nonnull
    public static UnaryOperator<BigDecimal> plus(@Nullable BigDecimal a) {
        return b -> Operators.plus(a, b);
    }

    public static <N extends Number> N plus(@Nullable N a, @Nullable N b) {
        if (a instanceof Integer && b instanceof Integer) {
            return (N)Integer.valueOf((Integer)a + (Integer)b);
        }
        if (a instanceof Long && b instanceof Long) {
            return (N)Long.valueOf((Long)a + (Long)b);
        }
        if (a instanceof Double && b instanceof Double) {
            return (N)Double.valueOf((Double)a + (Double)b);
        }
        if (a instanceof BigInteger && b instanceof BigInteger) {
            return (N)((BigInteger)a).add((BigInteger)b);
        }
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            return (N)((BigDecimal)a).add((BigDecimal)b);
        }
        return null;
    }

    @Nonnull
    public static <N extends Number> UnaryOperator<N> plus(@Nullable N a) {
        return b -> Operators.plus(a, b);
    }

    public static int or(int a, int b) {
        return a | b;
    }

    @Nonnull
    public static IntUnaryOperator or(int a) {
        return b -> a | b;
    }

    public static long or(long a, long b) {
        return a | b;
    }

    @Nonnull
    public static LongUnaryOperator or(long a) {
        return b -> a | b;
    }

    public static Integer or(@Nullable Integer a, @Nullable Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a | b;
    }

    @Nonnull
    public static UnaryOperator<Integer> or(@Nullable Integer a) {
        return b -> Operators.or(a, b);
    }

    public static Long or(@Nullable Long a, @Nullable Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a | b;
    }

    @Nonnull
    public static UnaryOperator<Long> or(@Nullable Long a) {
        return b -> Operators.or(a, b);
    }

    public static BigInteger or(@Nullable BigInteger a, @Nullable BigInteger b) {
        if (a == null || b == null) {
            return null;
        }
        return a.or(b);
    }

    @Nonnull
    public static UnaryOperator<BigInteger> or(@Nullable BigInteger a) {
        return b -> Operators.or(a, b);
    }

    public static <N extends Number> N or(@Nullable N a, @Nullable N b) {
        if (a instanceof Integer && b instanceof Integer) {
            return (N)Integer.valueOf((Integer)a | (Integer)b);
        }
        if (a instanceof Long && b instanceof Long) {
            return (N)Long.valueOf((Long)a | (Long)b);
        }
        if (a instanceof BigInteger && b instanceof BigInteger) {
            return (N)((BigInteger)a).or((BigInteger)b);
        }
        return null;
    }

    @Nonnull
    public static <N extends Number> UnaryOperator<N> or(@Nullable N a) {
        return b -> Operators.or(a, b);
    }

    public static int minus(int a, int b) {
        return a - b;
    }

    @Nonnull
    public static IntUnaryOperator minus(int b) {
        return a -> a - b;
    }

    public static long minus(long a, long b) {
        return a - b;
    }

    @Nonnull
    public static LongUnaryOperator minus(long b) {
        return a -> a - b;
    }

    public static double minus(double a, double b) {
        return a - b;
    }

    @Nonnull
    public static DoubleUnaryOperator minus(double b) {
        return a -> a - b;
    }

    public static Integer minus(@Nullable Integer a, @Nullable Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a - b;
    }

    @Nonnull
    public static UnaryOperator<Integer> minus(@Nullable Integer b) {
        return a -> Operators.minus(a, b);
    }

    public static Long minus(@Nullable Long a, @Nullable Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a - b;
    }

    @Nonnull
    public static UnaryOperator<Long> minus(@Nullable Long b) {
        return a -> Operators.minus(a, b);
    }

    public static Double minus(@Nullable Double a, @Nullable Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a - b;
    }

    @Nonnull
    public static UnaryOperator<Double> minus(@Nullable Double b) {
        return a -> Operators.minus(a, b);
    }

    public static BigInteger minus(@Nullable BigInteger a, @Nullable BigInteger b) {
        if (a == null || b == null) {
            return null;
        }
        return a.subtract(b);
    }

    @Nonnull
    public static UnaryOperator<BigInteger> minus(@Nullable BigInteger b) {
        return a -> Operators.minus(a, b);
    }

    public static BigDecimal minus(@Nullable BigDecimal a, @Nullable BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        return a.subtract(b);
    }

    @Nonnull
    public static UnaryOperator<BigDecimal> minus(@Nullable BigDecimal b) {
        return a -> Operators.minus(a, b);
    }

    public static <N extends Number> N minus(@Nullable N a, @Nullable N b) {
        if (a instanceof Integer && b instanceof Integer) {
            return (N)Integer.valueOf((Integer)a - (Integer)b);
        }
        if (a instanceof Long && b instanceof Long) {
            return (N)Long.valueOf((Long)a - (Long)b);
        }
        if (a instanceof Double && b instanceof Double) {
            return (N)Double.valueOf((Double)a - (Double)b);
        }
        if (a instanceof BigInteger && b instanceof BigInteger) {
            return (N)((BigInteger)a).subtract((BigInteger)b);
        }
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            return (N)((BigDecimal)a).subtract((BigDecimal)b);
        }
        return null;
    }

    @Nonnull
    public static <N extends Number> UnaryOperator<N> minus(@Nullable N b) {
        return a -> Operators.minus(a, b);
    }

    public static int times(int a, int b) {
        return a * b;
    }

    @Nonnull
    public static IntUnaryOperator times(int a) {
        return b -> a * b;
    }

    public static long times(long a, long b) {
        return a * b;
    }

    @Nonnull
    public static LongUnaryOperator times(long a) {
        return b -> a * b;
    }

    public static double times(double a, double b) {
        return a * b;
    }

    @Nonnull
    public static DoubleUnaryOperator times(double a) {
        return b -> a * b;
    }

    public static Integer times(Integer a, Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a * b;
    }

    @Nonnull
    public static UnaryOperator<Integer> times(@Nullable Integer a) {
        return b -> Operators.times(a, b);
    }

    public static Long times(Long a, Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a * b;
    }

    @Nonnull
    public static UnaryOperator<Long> times(@Nullable Long a) {
        return b -> Operators.times(a, b);
    }

    public static Double times(Double a, Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a * b;
    }

    @Nonnull
    public static UnaryOperator<Double> times(@Nullable Double a) {
        return b -> Operators.times(a, b);
    }

    public static BigInteger times(BigInteger a, BigInteger b) {
        if (a == null || b == null) {
            return null;
        }
        return a.multiply(b);
    }

    @Nonnull
    public static UnaryOperator<BigInteger> times(@Nullable BigInteger a) {
        return b -> Operators.times(a, b);
    }

    public static BigDecimal times(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        return a.multiply(b);
    }

    @Nonnull
    public static UnaryOperator<BigDecimal> times(@Nullable BigDecimal a) {
        return b -> Operators.times(a, b);
    }

    public static <N extends Number> N times(@Nullable N a, @Nullable N b) {
        if (a instanceof Integer && b instanceof Integer) {
            return (N)Integer.valueOf((Integer)a * (Integer)b);
        }
        if (a instanceof Long && b instanceof Long) {
            return (N)Long.valueOf((Long)a * (Long)b);
        }
        if (a instanceof Double && b instanceof Double) {
            return (N)Double.valueOf((Double)a * (Double)b);
        }
        if (a instanceof BigInteger && b instanceof BigInteger) {
            return (N)((BigInteger)a).multiply((BigInteger)b);
        }
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            return (N)((BigDecimal)a).multiply((BigDecimal)b);
        }
        return null;
    }

    @Nonnull
    public static <N extends Number> UnaryOperator<N> times(@Nullable N a) {
        return b -> Operators.times(a, b);
    }

    public static int and(int a, int b) {
        return a & b;
    }

    @Nonnull
    public static IntUnaryOperator and(int a) {
        return b -> a & b;
    }

    public static long and(long a, long b) {
        return a & b;
    }

    @Nonnull
    public static LongUnaryOperator and(long a) {
        return b -> a & b;
    }

    public static Integer and(@Nullable Integer a, @Nullable Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a & b;
    }

    @Nonnull
    public static UnaryOperator<Integer> and(@Nullable Integer a) {
        return b -> Operators.and(a, b);
    }

    public static Long and(@Nullable Long a, @Nullable Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a & b;
    }

    @Nonnull
    public static UnaryOperator<Long> and(@Nullable Long a) {
        return b -> Operators.and(a, b);
    }

    public static BigInteger and(@Nullable BigInteger a, @Nullable BigInteger b) {
        if (a == null || b == null) {
            return null;
        }
        return a.and(b);
    }

    @Nonnull
    public static UnaryOperator<BigInteger> and(@Nullable BigInteger a) {
        return b -> Operators.and(a, b);
    }

    public static <N extends Number> N and(@Nullable N a, @Nullable N b) {
        if (a instanceof Integer && b instanceof Integer) {
            return (N)Integer.valueOf((Integer)a & (Integer)b);
        }
        if (a instanceof Long && b instanceof Long) {
            return (N)Long.valueOf((Long)a & (Long)b);
        }
        if (a instanceof BigInteger && b instanceof BigInteger) {
            return (N)((BigInteger)a).and((BigInteger)b);
        }
        return null;
    }

    @Nonnull
    public static <N extends Number> UnaryOperator<N> and(@Nullable N a) {
        return b -> Operators.and(a, b);
    }

    public static int div(int a, int b) {
        return a / b;
    }

    @Nonnull
    public static IntUnaryOperator div(int b) {
        return a -> a / b;
    }

    public static long div(long a, long b) {
        return a / b;
    }

    @Nonnull
    public static LongUnaryOperator div(long b) {
        return a -> a / b;
    }

    public static double div(double a, double b) {
        return a / b;
    }

    @Nonnull
    public static DoubleUnaryOperator div(double b) {
        return a -> a / b;
    }

    public static Integer div(@Nullable Integer a, @Nullable Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a / b;
    }

    @Nonnull
    public static UnaryOperator<Integer> div(@Nullable Integer b) {
        return a -> Operators.div(a, b);
    }

    public static Long div(@Nullable Long a, @Nullable Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a / b;
    }

    @Nonnull
    public static UnaryOperator<Long> div(@Nullable Long b) {
        return a -> Operators.div(a, b);
    }

    public static Double div(@Nullable Double a, @Nullable Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a / b;
    }

    @Nonnull
    public static UnaryOperator<Double> div(@Nullable Double b) {
        return a -> Operators.div(a, b);
    }

    public static BigInteger div(@Nullable BigInteger a, @Nullable BigInteger b) {
        if (a == null || b == null) {
            return null;
        }
        return a.divide(b);
    }

    @Nonnull
    public static UnaryOperator<BigInteger> div(@Nullable BigInteger b) {
        return a -> Operators.div(a, b);
    }

    public static BigDecimal div(@Nullable BigDecimal a, @Nullable BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        return a.divide(b, RoundingMode.HALF_EVEN);
    }

    @Nonnull
    public static UnaryOperator<BigDecimal> div(@Nullable BigDecimal b) {
        return a -> Operators.div(a, b);
    }

    public static <N extends Number> N div(@Nullable N a, @Nullable N b) {
        if (a instanceof Integer && b instanceof Integer) {
            return (N)Integer.valueOf((Integer)a / (Integer)b);
        }
        if (a instanceof Long && b instanceof Long) {
            return (N)Long.valueOf((Long)a / (Long)b);
        }
        if (a instanceof Double && b instanceof Double) {
            return (N)Double.valueOf((Double)a / (Double)b);
        }
        if (a instanceof BigInteger && b instanceof BigInteger) {
            return (N)((BigInteger)a).divide((BigInteger)b);
        }
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            return (N)((BigDecimal)a).divide((BigDecimal)b, RoundingMode.HALF_EVEN);
        }
        return null;
    }

    @Nonnull
    public static <N extends Number> UnaryOperator<N> div(@Nullable N b) {
        return a -> Operators.div(a, b);
    }

    public static int mod(int a, int b) {
        return a % b;
    }

    @Nonnull
    public static IntUnaryOperator mod(int b) {
        return a -> a % b;
    }

    public static long mod(long a, long b) {
        return a % b;
    }

    @Nonnull
    public static LongUnaryOperator mod(long b) {
        return a -> a % b;
    }

    public static double mod(double a, double b) {
        return a % b;
    }

    @Nonnull
    public static DoubleUnaryOperator mod(double b) {
        return a -> a % b;
    }

    public static Integer mod(@Nullable Integer a, @Nullable Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a % b;
    }

    @Nonnull
    public static UnaryOperator<Integer> mod(@Nullable Integer b) {
        return a -> Operators.mod(a, b);
    }

    public static Long mod(@Nullable Long a, @Nullable Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a % b;
    }

    @Nonnull
    public static UnaryOperator<Long> mod(@Nullable Long b) {
        return a -> Operators.mod(a, b);
    }

    public static Double mod(Double a, Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a % b;
    }

    @Nonnull
    public static UnaryOperator<Double> mod(@Nullable Double b) {
        return a -> Operators.mod(a, b);
    }

    public static BigInteger mod(BigInteger a, BigInteger b) {
        if (a == null || b == null) {
            return null;
        }
        return a.mod(b);
    }

    @Nonnull
    public static UnaryOperator<BigInteger> mod(@Nullable BigInteger b) {
        return a -> Operators.mod(a, b);
    }

    public static <N extends Number> N mod(@Nullable N a, @Nullable N b) {
        if (a instanceof Integer && b instanceof Integer) {
            return (N)Integer.valueOf((Integer)a % (Integer)b);
        }
        if (a instanceof Long && b instanceof Long) {
            return (N)Long.valueOf((Long)a % (Long)b);
        }
        if (a instanceof Double && b instanceof Double) {
            return (N)Double.valueOf((Double)a % (Double)b);
        }
        if (a instanceof BigInteger && b instanceof BigInteger) {
            return (N)((BigInteger)a).mod((BigInteger)b);
        }
        return null;
    }

    @Nonnull
    public static <N extends Number> UnaryOperator<N> mod(@Nullable N b) {
        return a -> Operators.mod(a, b);
    }

    public static int xor(int a, int b) {
        return a ^ b;
    }

    @Nonnull
    public static IntUnaryOperator xor(int b) {
        return a -> a ^ b;
    }

    public static long xor(long a, long b) {
        return a ^ b;
    }

    @Nonnull
    public static LongUnaryOperator xor(long b) {
        return a -> a ^ b;
    }

    public static Integer xor(@Nullable Integer a, @Nullable Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a ^ b;
    }

    @Nonnull
    public static UnaryOperator<Integer> xor(@Nullable Integer b) {
        return a -> Operators.xor(a, b);
    }

    public static Long xor(@Nullable Long a, @Nullable Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a ^ b;
    }

    @Nonnull
    public static UnaryOperator<Long> xor(@Nullable Long b) {
        return a -> Operators.xor(a, b);
    }

    public static BigInteger xor(@Nullable BigInteger a, @Nullable BigInteger b) {
        if (a == null || b == null) {
            return null;
        }
        return a.xor(b);
    }

    @Nonnull
    public static UnaryOperator<BigInteger> xor(@Nullable BigInteger b) {
        return a -> Operators.xor(a, b);
    }

    public static <N extends Number> N xor(@Nullable N a, @Nullable N b) {
        if (a instanceof Integer && b instanceof Integer) {
            return (N)Integer.valueOf((Integer)a ^ (Integer)b);
        }
        if (a instanceof Long && b instanceof Long) {
            return (N)Long.valueOf((Long)a ^ (Long)b);
        }
        if (a instanceof BigInteger && b instanceof BigInteger) {
            return (N)((BigInteger)a).xor((BigInteger)b);
        }
        return null;
    }

    @Nonnull
    public static <N extends Number> UnaryOperator<N> xor(@Nullable N b) {
        return a -> Operators.xor(a, b);
    }

    public static boolean neq(boolean a, boolean b) {
        return a != b;
    }

    public static boolean neq(int a, int b) {
        return a != b;
    }

    public static boolean neq(long a, long b) {
        return a != b;
    }

    public static boolean neq(double a, double b) {
        return a != b;
    }

    public static Boolean neq(@Nullable Object a, @Nullable Object b) {
        if (a == null || b == null) {
            return null;
        }
        return !a.equals(b);
    }

    public static boolean eq(boolean a, boolean b) {
        return a == b;
    }

    public static boolean eq(int a, int b) {
        return a == b;
    }

    public static boolean eq(long a, long b) {
        return a == b;
    }

    public static boolean eq(double a, double b) {
        return a == b;
    }

    public static Boolean eq(@Nullable Object a, @Nullable Object b) {
        if (a == null || b == null) {
            return null;
        }
        return a.equals(b);
    }

    public static boolean lt(int a, int b) {
        return a < b;
    }

    public static boolean lt(long a, long b) {
        return a < b;
    }

    public static boolean lt(double a, double b) {
        return a < b;
    }

    public static Boolean lt(Integer a, Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a < b;
    }

    public static Boolean lt(Long a, Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a < b;
    }

    public static Boolean lt(Double a, Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a < b;
    }

    public static <E extends Comparable<? super E>> Boolean lt(E a, E b) {
        if (a == null || b == null) {
            return null;
        }
        return a.compareTo(b) < 0;
    }

    public static boolean lte(int a, int b) {
        return a <= b;
    }

    public static boolean lte(long a, long b) {
        return a <= b;
    }

    public static boolean lte(double a, double b) {
        return a <= b;
    }

    public static Boolean lte(Integer a, Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a <= b;
    }

    public static Boolean lte(Long a, Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a <= b;
    }

    public static Boolean lte(Double a, Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a <= b;
    }

    public static <E extends Comparable<? super E>> Boolean lte(E a, E b) {
        if (a == null || b == null) {
            return null;
        }
        return a.compareTo(b) <= 0;
    }

    public static boolean gt(int a, int b) {
        return a > b;
    }

    public static boolean gt(long a, long b) {
        return a > b;
    }

    public static boolean gt(double a, double b) {
        return a > b;
    }

    public static Boolean gt(Integer a, Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a > b;
    }

    public static Boolean gt(Long a, Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a > b;
    }

    public static Boolean gt(Double a, Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a > b;
    }

    public static <E extends Comparable<? super E>> Boolean gt(E a, E b) {
        if (a == null || b == null) {
            return null;
        }
        return a.compareTo(b) > 0;
    }

    public static boolean gte(int a, int b) {
        return a >= b;
    }

    public static boolean gte(long a, long b) {
        return a >= b;
    }

    public static boolean gte(double a, double b) {
        return a >= b;
    }

    public static Boolean gte(Integer a, Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a >= b;
    }

    public static Boolean gte(Long a, Long b) {
        if (a == null || b == null) {
            return null;
        }
        return a >= b;
    }

    public static Boolean gte(Double a, Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a >= b;
    }

    public static <E extends Comparable<? super E>> Boolean gte(E a, E b) {
        if (a == null || b == null) {
            return null;
        }
        return a.compareTo(b) >= 0;
    }

    @Generated
    private Operators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

