/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Control;
import de.scravy.bedrock.Reflections;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.DoublePredicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class Numbers {
    @Nonnull
    public static <N extends Number> N zero(Class<N> numberClass) {
        Class<?> clazz = Reflections.getBoxedClassFor(numberClass);
        if (Integer.class.equals(clazz)) {
            return (N)Integer.valueOf(0);
        }
        if (Long.class.equals(clazz)) {
            return (N)Long.valueOf(0L);
        }
        if (Short.class.equals(clazz)) {
            return (N)Short.valueOf((short)0);
        }
        if (Byte.class.equals(clazz)) {
            return (N)Byte.valueOf((byte)0);
        }
        if (Double.class.equals(clazz)) {
            return (N)Double.valueOf(0.0);
        }
        if (Float.class.equals(clazz)) {
            return (N)Float.valueOf(0.0f);
        }
        if (BigInteger.class.equals(clazz)) {
            return (N)BigInteger.ZERO;
        }
        if (BigDecimal.class.equals(clazz)) {
            return (N)BigDecimal.ZERO;
        }
        return (N)((Number)Control.findFirstNonNull(clazz, c -> Reflections.getFactory(String.class, c).map(factory -> (Number)factory.apply("0")).orElse(null), c -> Reflections.getFactory(Integer.TYPE, c).map(factory -> (Number)factory.apply(0)).orElse(null), c -> Reflections.getFactory(Long.TYPE, c).map(factory -> (Number)factory.apply(0L)).orElse(null)).orElseThrow(() -> new IllegalArgumentException(Objects.toString(clazz))));
    }

    @Nonnull
    public static <N extends Number> N one(Class<N> numberClass) {
        Class<?> clazz = Reflections.getBoxedClassFor(numberClass);
        if (Integer.class.equals(clazz)) {
            return (N)Integer.valueOf(1);
        }
        if (Long.class.equals(clazz)) {
            return (N)Long.valueOf(1L);
        }
        if (Short.class.equals(clazz)) {
            return (N)Short.valueOf((short)1);
        }
        if (Byte.class.equals(clazz)) {
            return (N)Byte.valueOf((byte)1);
        }
        if (Double.class.equals(clazz)) {
            return (N)Double.valueOf(1.0);
        }
        if (Float.class.equals(clazz)) {
            return (N)Float.valueOf(1.0f);
        }
        if (BigInteger.class.equals(clazz)) {
            return (N)BigInteger.ONE;
        }
        if (BigDecimal.class.equals(clazz)) {
            return (N)BigDecimal.ONE;
        }
        return (N)((Number)Control.findFirstNonNull(clazz, c -> Reflections.getFactory(String.class, c).map(factory -> (Number)factory.apply("1")).orElse(null), c -> Reflections.getFactory(Integer.TYPE, c).map(factory -> (Number)factory.apply(1)).orElse(null), c -> Reflections.getFactory(Long.TYPE, c).map(factory -> (Number)factory.apply(1L)).orElse(null)).orElseThrow(() -> new IllegalArgumentException(Objects.toString(clazz))));
    }

    public static DoublePredicate isApproximately(double expected, double error) {
        return value -> Math.abs(expected - value) < error;
    }

    public static int byteToInt(byte b) {
        return b & 0xFF;
    }

    public static int intFromBytes(byte b0, byte b1, byte b2, byte b3) {
        int value = 0;
        value |= Numbers.byteToInt(b0);
        value <<= 8;
        value |= Numbers.byteToInt(b1);
        value <<= 8;
        value |= Numbers.byteToInt(b2);
        value <<= 8;
        return value |= Numbers.byteToInt(b3);
    }

    public static int intFromByteArray(@Nonnull byte[] bytes) {
        Objects.requireNonNull(bytes, "'bytes' must not be null.");
        return Numbers.intFromByteArrayAtOffset(0, bytes);
    }

    public static int intFromByteArrayAtOffset(@Nonnegative int offset, @Nonnull byte[] bytes) {
        Objects.requireNonNull(bytes, "'bytes' must not be null.");
        return Numbers.intFromBytes(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]);
    }

    public static long longFromBytes(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
        long value = 0L;
        value |= (long)Numbers.byteToInt(b0);
        value <<= 8;
        value |= (long)Numbers.byteToInt(b1);
        value <<= 8;
        value |= (long)Numbers.byteToInt(b2);
        value <<= 8;
        value |= (long)Numbers.byteToInt(b3);
        value <<= 8;
        value |= (long)Numbers.byteToInt(b4);
        value <<= 8;
        value |= (long)Numbers.byteToInt(b5);
        value <<= 8;
        value |= (long)Numbers.byteToInt(b6);
        value <<= 8;
        return value |= (long)Numbers.byteToInt(b7);
    }

    public static long longFromByteArray(@Nonnull byte[] bytes) {
        Objects.requireNonNull(bytes, "'bytes' must not be null.");
        return Numbers.longFromByteArrayAtOffset(0, bytes);
    }

    public static long longFromByteArrayAtOffset(@Nonnegative int offset, @Nonnull byte[] bytes) {
        Objects.requireNonNull(bytes, "'bytes' must not be null.");
        return Numbers.longFromBytes(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4], bytes[offset + 5], bytes[offset + 6], bytes[offset + 7]);
    }

    @Generated
    private Numbers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

