/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.ExtendedIterable;
import de.scravy.bedrock.Function1;
import de.scravy.bedrock.Pair;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqBuilder;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Mapping<From, To>
extends Function1<From, To>,
ExtendedIterable<Pair<From, To>> {
    @Nonnull
    public Optional<To> get(From var1);

    public Seq<From> keys();

    default public To getOrElse(From key, To fallback) {
        return this.get(key).orElse(fallback);
    }

    @Nullable
    default public To getOrNull(From key) {
        return this.get(key).orElse(null);
    }

    @Override
    default public To apply(From key) {
        Optional<To> result = this.get(key);
        if (result.isPresent()) {
            return result.get();
        }
        throw new NoSuchElementException(Objects.toString(key));
    }

    default public int size() {
        return this.keys().length();
    }

    default public boolean isEmpty() {
        return this.keys().isEmpty();
    }

    default public Seq<To> values() {
        SeqBuilder builder = Seq.builder();
        for (From key : this.keys()) {
            builder.add(this.apply(key));
        }
        return builder.result();
    }

    @Override
    @Nonnull
    default public Iterator<Pair<From, To>> iterator() {
        return new Iterator<Pair<From, To>>(){
            private final Iterator<From> underlying;
            {
                this.underlying = Mapping.this.keys().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.underlying.hasNext();
            }

            @Override
            public Pair<From, To> next() {
                Object nextKey = this.underlying.next();
                return Pair.of(nextKey, Mapping.this.apply(nextKey));
            }
        };
    }

    default public Stream<Pair<From, To>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Map<From, To> toMap() {
        return new AbstractMap<From, To>(){
            private SoftReference<Set<Map.Entry<From, To>>> entrySet = new SoftReference<Object>(null);

            @Override
            @Nonnull
            public Set<Map.Entry<From, To>> entrySet() {
                Set entrySet = this.entrySet.get();
                if (entrySet == null) {
                    HashSet set = new HashSet();
                    for (Object key : Mapping.this.keys()) {
                        set.add(Pair.of(key, Mapping.this.apply(key)));
                    }
                    this.entrySet = new SoftReference(set);
                    return set;
                }
                return entrySet;
            }
        };
    }

    default public void forEach(BiConsumer<? super From, ? super To> action) {
        Objects.requireNonNull(action, "'action' must not be null");
        for (Pair<From, To> t : this) {
            action.accept(t.fst(), t.snd());
        }
    }

    public static <From, To> Mapping<From, To> wrap(final Map<From, To> map) {
        return new Mapping<From, To>(){
            private SoftReference<Seq<From>> keys = new SoftReference<Object>(null);
            private SoftReference<Seq<To>> values = new SoftReference<Object>(null);

            @Override
            @Nonnull
            public Map<From, To> toMap() {
                return map;
            }

            @Override
            @Nonnull
            public Iterator<Pair<From, To>> iterator() {
                return new Iterator<Pair<From, To>>(){
                    private final Iterator<Map.Entry<From, To>> underlying;
                    {
                        this.underlying = map.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.underlying.hasNext();
                    }

                    @Override
                    public Pair<From, To> next() {
                        return Pair.of(this.underlying.next());
                    }
                };
            }

            @Override
            @Nonnull
            public Optional<To> get(From key) {
                if (map.containsKey(key)) {
                    return Optional.ofNullable(map.get(key));
                }
                return Optional.empty();
            }

            @Override
            public Seq<From> keys() {
                Seq keys = this.keys.get();
                if (keys == null) {
                    Seq newKeys = Seq.ofCollection(map.keySet());
                    this.keys = new SoftReference(newKeys);
                    return newKeys;
                }
                return keys;
            }

            @Override
            public Seq<To> values() {
                Seq values = this.values.get();
                if (values == null) {
                    Seq newValues = Seq.ofCollection(map.values());
                    this.values = new SoftReference(newValues);
                    return newValues;
                }
                return values;
            }
        };
    }

    public static <K, V> Mapping<K, V> empty() {
        return EmptyMapping.EMPTY;
    }

    public static class EmptyMapping<K, V>
    implements Mapping<K, V> {
        private static EmptyMapping EMPTY = new EmptyMapping();

        @Override
        @Nonnull
        public Optional<V> get(K key) {
            return Optional.empty();
        }

        @Override
        public Seq<K> keys() {
            return Seq.empty();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof Mapping && ((Mapping)obj).isEmpty();
        }

        public int hashCode() {
            return 1;
        }
    }
}

