/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Numbers;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import lombok.Generated;

public interface Hash<H extends Hash<H>>
extends Comparable<H> {
    public byte[] getBytes();

    @Override
    default public int compareTo(H hash) {
        return this.toString().compareTo(hash.toString());
    }

    public static abstract class Hash512<H extends Hash<H>>
    implements Hash<H> {
        static final int LENGTH = 64;
        private final long v0;
        private final long v1;
        private final long v2;
        private final long v3;
        private final long v4;
        private final long v5;
        private final long v6;
        private final long v7;

        Hash512(byte[] digest) {
            this(Numbers.longFromBytes(digest[0], digest[1], digest[2], digest[3], digest[4], digest[5], digest[6], digest[7]), Numbers.longFromBytes(digest[8], digest[9], digest[10], digest[11], digest[12], digest[13], digest[14], digest[15]), Numbers.longFromBytes(digest[16], digest[17], digest[18], digest[19], digest[20], digest[21], digest[22], digest[23]), Numbers.longFromBytes(digest[24], digest[25], digest[26], digest[27], digest[28], digest[29], digest[30], digest[31]), Numbers.longFromBytes(digest[32], digest[33], digest[34], digest[35], digest[36], digest[37], digest[38], digest[39]), Numbers.longFromBytes(digest[40], digest[41], digest[42], digest[43], digest[44], digest[45], digest[46], digest[47]), Numbers.longFromBytes(digest[48], digest[49], digest[50], digest[51], digest[52], digest[53], digest[54], digest[55]), Numbers.longFromBytes(digest[56], digest[57], digest[58], digest[59], digest[60], digest[61], digest[62], digest[63]));
        }

        @Override
        @Nonnull
        public byte[] getBytes() {
            byte[] result = new byte[64];
            ByteBuffer bb = ByteBuffer.wrap(result);
            bb.putLong(this.v0);
            bb.putLong(this.v1);
            bb.putLong(this.v2);
            bb.putLong(this.v3);
            bb.putLong(this.v4);
            bb.putLong(this.v5);
            bb.putLong(this.v6);
            bb.putLong(this.v7);
            return result;
        }

        @Nonnull
        public String toString() {
            return String.format("%016x%016x%016x%016x%016x%016x%016x%016x", this.v0, this.v1, this.v2, this.v3, this.v4, this.v5, this.v6, this.v7);
        }

        @Override
        public int compareTo(H hash) {
            return this.toString().compareTo(hash.toString());
        }

        @Generated
        private Hash512(long v0, long v1, long v2, long v3, long v4, long v5, long v6, long v7) {
            this.v0 = v0;
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.v4 = v4;
            this.v5 = v5;
            this.v6 = v6;
            this.v7 = v7;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Hash512)) {
                return false;
            }
            Hash512 other = (Hash512)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.v0 != other.v0) {
                return false;
            }
            if (this.v1 != other.v1) {
                return false;
            }
            if (this.v2 != other.v2) {
                return false;
            }
            if (this.v3 != other.v3) {
                return false;
            }
            if (this.v4 != other.v4) {
                return false;
            }
            if (this.v5 != other.v5) {
                return false;
            }
            if (this.v6 != other.v6) {
                return false;
            }
            return this.v7 == other.v7;
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Hash512;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $v0 = this.v0;
            result = result * 59 + (int)($v0 >>> 32 ^ $v0);
            long $v1 = this.v1;
            result = result * 59 + (int)($v1 >>> 32 ^ $v1);
            long $v2 = this.v2;
            result = result * 59 + (int)($v2 >>> 32 ^ $v2);
            long $v3 = this.v3;
            result = result * 59 + (int)($v3 >>> 32 ^ $v3);
            long $v4 = this.v4;
            result = result * 59 + (int)($v4 >>> 32 ^ $v4);
            long $v5 = this.v5;
            result = result * 59 + (int)($v5 >>> 32 ^ $v5);
            long $v6 = this.v6;
            result = result * 59 + (int)($v6 >>> 32 ^ $v6);
            long $v7 = this.v7;
            result = result * 59 + (int)($v7 >>> 32 ^ $v7);
            return result;
        }
    }

    public static abstract class Hash256<H extends Hash<H>>
    implements Hash<H> {
        static final int LENGTH = 32;
        private final long v0;
        private final long v1;
        private final long v2;
        private final long v3;

        Hash256(byte[] digest) {
            this(Numbers.longFromBytes(digest[0], digest[1], digest[2], digest[3], digest[4], digest[5], digest[6], digest[7]), Numbers.longFromBytes(digest[8], digest[9], digest[10], digest[11], digest[12], digest[13], digest[14], digest[15]), Numbers.longFromBytes(digest[16], digest[17], digest[18], digest[19], digest[20], digest[21], digest[22], digest[23]), Numbers.longFromBytes(digest[24], digest[25], digest[26], digest[27], digest[28], digest[29], digest[30], digest[31]));
        }

        @Override
        @Nonnull
        public byte[] getBytes() {
            byte[] result = new byte[32];
            ByteBuffer bb = ByteBuffer.wrap(result);
            bb.putLong(this.v0);
            bb.putLong(this.v1);
            bb.putLong(this.v2);
            bb.putLong(this.v3);
            return result;
        }

        @Nonnull
        public String toString() {
            return String.format("%016x%016x%016x%016x", this.v0, this.v1, this.v2, this.v3);
        }

        @Generated
        private Hash256(long v0, long v1, long v2, long v3) {
            this.v0 = v0;
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Hash256)) {
                return false;
            }
            Hash256 other = (Hash256)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.v0 != other.v0) {
                return false;
            }
            if (this.v1 != other.v1) {
                return false;
            }
            if (this.v2 != other.v2) {
                return false;
            }
            return this.v3 == other.v3;
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Hash256;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $v0 = this.v0;
            result = result * 59 + (int)($v0 >>> 32 ^ $v0);
            long $v1 = this.v1;
            result = result * 59 + (int)($v1 >>> 32 ^ $v1);
            long $v2 = this.v2;
            result = result * 59 + (int)($v2 >>> 32 ^ $v2);
            long $v3 = this.v3;
            result = result * 59 + (int)($v3 >>> 32 ^ $v3);
            return result;
        }
    }
}

