/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.DirectedGraph;
import de.scravy.bedrock.Pair;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqBuilder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class Graphs {
    @Nonnull
    public static <V> Optional<Seq<V>> topologicalSort(Seq<Pair<V, V>> edges) {
        SeqBuilder resultBuilder = Seq.builder();
        HashMap<Object, Set> incomingEdgesMap = new HashMap<Object, Set>();
        HashMap outgoingEdgesMap = new HashMap();
        edges.forEach(edge -> {
            incomingEdgesMap.computeIfAbsent(edge.fst(), __ -> new HashSet());
            incomingEdgesMap.computeIfAbsent(edge.snd(), __ -> new HashSet());
            outgoingEdgesMap.computeIfAbsent(edge.fst(), __ -> new HashSet());
            outgoingEdgesMap.computeIfAbsent(edge.snd(), __ -> new HashSet());
        });
        edges.forEach(edge -> ((Set)incomingEdgesMap.get(edge.getSecond())).add(edge.getFirst()));
        edges.forEach(edge -> ((Set)outgoingEdgesMap.get(edge.getFirst())).add(edge.getSecond()));
        int count = outgoingEdgesMap.size();
        ArrayDeque nodes = new ArrayDeque();
        incomingEdgesMap.forEach((to, from) -> {
            if (from.isEmpty()) {
                nodes.addFirst(to);
            }
        });
        while (!nodes.isEmpty()) {
            Object n = nodes.removeFirst();
            resultBuilder.add(n);
            ((Set)outgoingEdgesMap.get(n)).forEach(m -> {
                Set incoming = (Set)incomingEdgesMap.get(m);
                incoming.remove(n);
                if (incoming.isEmpty()) {
                    nodes.addLast(m);
                }
            });
            --count;
        }
        return count == 0 ? Optional.of((Seq)resultBuilder.build()) : Optional.empty();
    }

    @Nonnull
    public static <V> Seq<Seq<V>> stronglyConnectedComponents(@Nonnull Seq<Pair<V, V>> edges) {
        DirectedGraph<V> graph = DirectedGraph.fromEdges(edges);
        return Graphs.stronglyConnectedComponents(graph);
    }

    @Nonnull
    public static <V> Seq<Seq<V>> stronglyConnectedComponents(@Nonnull DirectedGraph<V> graph) {
        class Algo {
            final int[] lowlink;
            final boolean[] onStack;
            final int[] indices;
            int index;
            final Deque<Integer> stack;
            final SeqBuilder<Seq<V>> result;
            final /* synthetic */ DirectedGraph val$graph;

            Algo(DirectedGraph directedGraph) {
                this.val$graph = directedGraph;
                this.lowlink = new int[this.val$graph.getNumberOfVertices()];
                this.onStack = new boolean[this.val$graph.getNumberOfVertices()];
                this.indices = new int[this.val$graph.getNumberOfVertices()];
                Arrays.fill(this.indices, -1);
                this.index = 0;
                this.stack = new ArrayDeque<Integer>();
                this.result = Seq.builder();
            }

            void strongConnect(int v) {
                this.lowlink[v] = this.index;
                this.indices[v] = this.index++;
                this.stack.push(v);
                this.onStack[v] = true;
                this.val$graph.forEachOutgoing(v, w -> {
                    if (this.indices[w] == -1) {
                        this.strongConnect(w);
                        this.lowlink[v] = Math.min(this.lowlink[v], this.lowlink[w]);
                    } else if (this.onStack[w]) {
                        this.lowlink[v] = Math.min(this.lowlink[v], this.indices[w]);
                    }
                });
                if (this.lowlink[v] == this.indices[v]) {
                    int x;
                    SeqBuilder sccBuilder = Seq.builder();
                    do {
                        x = this.stack.pop();
                        this.onStack[x] = false;
                        sccBuilder.add(this.val$graph.vertex(x));
                    } while (x != v);
                    this.result.add((Seq)sccBuilder.build());
                }
            }

            Seq<Seq<V>> result() {
                return this.result.result();
            }
        }
        Algo algo = new Algo(graph);
        for (int v = 0; v < graph.getNumberOfVertices(); ++v) {
            if (algo.indices[v] != -1) continue;
            algo.strongConnect(v);
        }
        return algo.result();
    }

    @Generated
    private Graphs() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

