/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Function1;
import de.scravy.bedrock.Function2;
import de.scravy.bedrock.Pair;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongBinaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class Functions {
    @Nonnull
    public static <A> UnaryOperator<A> id() {
        return x -> x;
    }

    @Nonnull
    public static <A, B> Function<B, A> constant(A a) {
        return ignored -> a;
    }

    @Nonnull
    public static <A> ToIntFunction<A> constantInt(int a) {
        return ignored -> a;
    }

    @Nonnull
    public static <A> ToLongFunction<A> constantLong(long a) {
        return ignored -> a;
    }

    @Nonnull
    public static <A> ToDoubleFunction<A> constantDouble(double a) {
        return ignored -> a;
    }

    @Nonnull
    public static <A> IntFunction<A> intConstant(A a) {
        return ignored -> a;
    }

    @Nonnull
    public static <A> LongFunction<A> longConstant(A a) {
        return ignored -> a;
    }

    @Nonnull
    public static <A> DoubleFunction<A> doubleConstant(A a) {
        return ignored -> a;
    }

    @Nonnull
    public static <A, B> Function<A, Function<B, A>> constant() {
        return a -> b -> a;
    }

    @Nonnull
    public static <A, B, C> Function<A, C> compose(@Nonnull Function<B, C> f, @Nonnull Function<A, B> g) {
        return a -> f.apply(g.apply(a));
    }

    @Nonnull
    public static <A, B, C> Function<A, Function<B, C>> curry(@Nonnull BiFunction<A, B, C> f) {
        return a -> b -> f.apply(a, b);
    }

    @Nonnull
    public static <A, B, C> Function<Pair<A, B>, C> curryPair(@Nonnull BiFunction<A, B, C> f) {
        return p -> f.apply(p.fst(), p.snd());
    }

    @Nonnull
    public static <A, B, C> Function<A, Function<B, C>> curry(@Nonnull Function<Pair<A, B>, C> f) {
        return a -> b -> f.apply(Pair.of(a, b));
    }

    @Nonnull
    public static <A, B, C> BiFunction<A, B, C> uncurry(@Nonnull Function<A, Function<B, C>> f) {
        return (a, b) -> ((Function)f.apply(a)).apply(b);
    }

    @Nonnull
    public static <A, B, C> Function<Pair<A, B>, C> uncurryPair(@Nonnull Function<A, Function<B, C>> f) {
        return p -> ((Function)f.apply(p.fst())).apply(p.snd());
    }

    @Nonnull
    public static <T> Predicate<T> not(@Nonnull Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        return predicate.negate();
    }

    @SafeVarargs
    @Nonnull
    public static <T> Predicate<T> and(Predicate<? extends T> ... ps) {
        return c -> {
            for (Predicate p : ps) {
                if (p.test(c)) continue;
                return false;
            }
            return true;
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T> Predicate<T> or(Predicate<? extends T> ... ps) {
        return c -> {
            for (Predicate p : ps) {
                if (!p.test(c)) continue;
                return true;
            }
            return false;
        };
    }

    @Nonnull
    public static <T> Predicate<T> predicate(@Nonnull Function<T, Boolean> predicate) {
        return predicate::apply;
    }

    @Nonnull
    public static <A, B, R> Function<B, R> bind(@Nonnull BiFunction<A, B, R> f, A a) {
        return b -> f.apply(a, b);
    }

    @Nonnull
    public static <A, B, R> Predicate<B> bindToBool(@Nonnull ToBooleanBiFunction<A, B> f, A a) {
        return b -> f.applyAsBool(a, b);
    }

    @Nonnull
    public static LongUnaryOperator bindLong(@Nonnull LongBinaryOperator f, long a) {
        return b -> f.applyAsLong(a, b);
    }

    @Nonnull
    public static DoubleUnaryOperator bindDouble(@Nonnull DoubleBinaryOperator f, double a) {
        return b -> f.applyAsDouble(a, b);
    }

    @Nonnull
    public static <A, B, R> Function2<B, A, R> flip(@Nonnull BiFunction<A, B, R> f) {
        return (a, b) -> f.apply(b, a);
    }

    public static <A, R> Function1<A, R> f1(Function<A, R> f) {
        return f::apply;
    }

    public static <A, B, R> Function2<A, B, R> f2(BiFunction<A, B, R> f) {
        return f::apply;
    }

    public static <T> void call(T arg, Consumer<T> consumer) {
        consumer.accept(arg);
    }

    public static <T, U> void call(T t, U u, BiConsumer<T, U> consumer) {
        consumer.accept(t, u);
    }

    public static <A, R> R apply(A arg, Function<A, R> f) {
        return f.apply(arg);
    }

    public static <A, B, R> R apply(A arg1, B arg2, BiFunction<A, B, R> f) {
        return f.apply(arg1, arg2);
    }

    @Generated
    private Functions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface ToBooleanBiFunction<A, B> {
        public boolean applyAsBool(A var1, B var2);
    }
}

