/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Tuple2;
import de.scravy.bedrock.Tuple3;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class ForEach {
    static <A> void forEach(@Nonnull Iterable<A> seq, @Nonnull Consumer<? super A> consumer) {
        Objects.requireNonNull(seq);
        Objects.requireNonNull(consumer);
        seq.forEach(consumer);
    }

    static <A> void forEach(@Nonnull Iterator<A> seq, @Nonnull Consumer<? super A> consumer) {
        Objects.requireNonNull(seq);
        Objects.requireNonNull(consumer);
        seq.forEachRemaining(consumer);
    }

    static <A, B> void forEach(@Nonnull Iterable<? extends Tuple2<A, B>> seq, @Nonnull BiConsumer<? super A, ? super B> consumer) {
        Objects.requireNonNull(seq);
        Objects.requireNonNull(consumer);
        seq.forEach(tuple -> consumer.accept((Object)tuple.getFirst(), (Object)tuple.getSecond()));
    }

    static <A, B, C> void forEach(@Nonnull Iterable<? extends Tuple3<A, B, C>> seq, @Nonnull TriConsumer<? super A, ? super B, ? super C> consumer) {
        Objects.requireNonNull(seq);
        Objects.requireNonNull(consumer);
        seq.forEach(triple -> consumer.accept((Object)triple.getFirst(), (Object)triple.getSecond(), (Object)triple.getThird()));
    }

    static <A> void forEach(@Nonnull A[] as, @Nonnull Consumer<? super A> consumer) {
        Objects.requireNonNull(as);
        Objects.requireNonNull(consumer);
        for (A a : as) {
            consumer.accept(a);
        }
    }

    static <A> void forEach(@Nonnull Optional<A> optional, @Nonnull Consumer<? super A> consumer) {
        Objects.requireNonNull(optional);
        Objects.requireNonNull(consumer);
        optional.ifPresent(consumer);
    }

    @Generated
    private ForEach() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }
}

