/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqBuilder;
import de.scravy.bedrock.Try;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.Generated;
import lombok.NonNull;

public final class DateTimes {
    @Nonnull
    public static Interval parseInterval(String string) {
        return Interval.parse(string);
    }

    @Nonnull
    public static Interval parseInterval(String begin, String end) {
        return Interval.parse(begin, end);
    }

    @Nonnull
    public static Instant parseInstant(String string) throws IllegalArgumentException {
        return Try.execute(() -> OffsetDateTime.parse(string).toInstant()).recover(__ -> LocalDateTime.parse(string).toInstant(ZoneOffset.UTC)).recover(__ -> DateTimes.parseDateTime(string).toInstant(ZoneOffset.UTC)).orElseDo(exc -> {
            throw new IllegalArgumentException(string + " failed to parse as an instant in time", (Throwable)exc);
        });
    }

    @Nonnull
    public static LocalDate toLocalDate(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC).toLocalDate();
    }

    @Nonnull
    public static LocalTime toLocalTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC).toLocalTime();
    }

    @Nonnull
    public static LocalDateTime parseDateTime(@NonNull String dateTime) throws IllegalArgumentException {
        if (dateTime == null) {
            throw new NullPointerException("dateTime is marked non-null but is null");
        }
        return DateTimes.parseDateTime(dateTime, 6);
    }

    @Nonnull
    public static LocalDateTime parseDateTime(@NonNull String dateTime, int numberOfComponents) throws IllegalArgumentException {
        if (dateTime == null) {
            throw new NullPointerException("dateTime is marked non-null but is null");
        }
        return Try.execute(() -> {
            Seq<Integer> components = Seq.concat((Seq)Seq.ofArray(dateTime.split("[^0-9]+")).flatMap(component -> {
                if (component.isEmpty()) {
                    return Seq.empty();
                }
                if (component.length() == 6) {
                    return Seq.of(component.substring(0, 2), component.substring(2, 4), component.substring(4, 6));
                }
                if (component.length() == 8) {
                    return Seq.of(component.substring(0, 4), component.substring(4, 6), component.substring(6, 8));
                }
                if (component.length() == 10) {
                    return Seq.of(component.substring(0, 4), component.substring(4, 6), component.substring(6, 8), component.substring(8, 10));
                }
                if (component.length() == 12) {
                    return Seq.of(component.substring(0, 4), component.substring(4, 6), component.substring(6, 8), component.substring(8, 10), component.substring(10, 12));
                }
                return Seq.of(component);
            }).take(numberOfComponents), Seq.ofGenerator(ignored -> "0", 6)).map(string -> Integer.parseInt(string, 10));
            LocalDateTime localDateTime = LocalDateTime.of((int)components.get(0), components.get(1), (int)components.get(2), (int)components.get(3), (int)components.get(4), (int)components.get(5));
            return localDateTime;
        }).orElseDo(exc -> {
            throw new IllegalArgumentException("", (Throwable)exc);
        });
    }

    @Generated
    private DateTimes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Interval {
        private final Instant begin;
        private final Instant end;

        @Nonnull
        public static Interval parse(String string) {
            int indexOfSlash = string.indexOf(47);
            if (indexOfSlash > 0) {
                String begin = string.substring(0, indexOfSlash);
                String end = string.substring(indexOfSlash + 1);
                try {
                    return Interval.parse(begin, end);
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException(string + " failed to parse as an Interval", exc);
                }
            }
            throw new IllegalArgumentException(string + " failed to parse as an Interval");
        }

        public static Interval parse(String begin, String end) {
            Instant beginInstant = DateTimes.parseInstant(begin);
            Instant endInstant = DateTimes.parseInstant(end);
            return Interval.of(beginInstant, endInstant);
        }

        public static Interval of(Instant beginInclusive, Instant endExclusive) {
            Objects.requireNonNull(beginInclusive, "'beginInclusive' must not be null");
            Objects.requireNonNull(endExclusive, "'endExclusive' must not be null");
            if (beginInclusive.isAfter(endExclusive)) {
                return new Interval(endExclusive, beginInclusive);
            }
            return new Interval(beginInclusive, endExclusive);
        }

        public Interval adjustBegin(Function<Instant, Instant> function) {
            return Interval.of(function.apply(this.begin), this.end);
        }

        public Interval adjustEnd(Function<Instant, Instant> function) {
            return Interval.of(this.begin, function.apply(this.end));
        }

        public Interval expandTo(TemporalUnit timeUnit) {
            Instant expandedBegin = this.begin.truncatedTo(timeUnit);
            Instant expandedEnd = this.end.truncatedTo(timeUnit).plus(1L, timeUnit);
            return new Interval(expandedBegin, expandedEnd);
        }

        public Seq<LocalDate> decomposeIntoDays() {
            Interval expandedToDays = this.expandTo(ChronoUnit.DAYS);
            SeqBuilder builder = Seq.builder();
            Instant start = expandedToDays.getBegin();
            while (start.compareTo(expandedToDays.getEnd()) < 0) {
                builder.add(DateTimes.toLocalDate(start));
                start = start.plus(1L, ChronoUnit.DAYS);
            }
            return builder.result();
        }

        public Duration getDuration() {
            return Duration.between(this.getBegin(), this.getEnd());
        }

        public String toString() {
            return this.getBegin() + "/" + this.getEnd();
        }

        @Generated
        public Instant getBegin() {
            return this.begin;
        }

        @Generated
        public Instant getEnd() {
            return this.end;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Interval)) {
                return false;
            }
            Interval other = (Interval)o;
            Instant this$begin = this.getBegin();
            Instant other$begin = other.getBegin();
            if (this$begin == null ? other$begin != null : !((Object)this$begin).equals(other$begin)) {
                return false;
            }
            Instant this$end = this.getEnd();
            Instant other$end = other.getEnd();
            return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Instant $begin = this.getBegin();
            result = result * 59 + ($begin == null ? 43 : ((Object)$begin).hashCode());
            Instant $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
            return result;
        }

        @Generated
        private Interval(Instant begin, Instant end) {
            this.begin = begin;
            this.end = end;
        }
    }
}

