/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Reflections;
import de.scravy.bedrock.Try;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public final class Conversions {
    public static <From, To> To fromTo(@Nonnull Class<From> from, @Nonnull Class<To> to, @Nullable From value) {
        if (value == null) {
            return null;
        }
        if (Reflections.getBoxedClassFor(to).isAssignableFrom(Reflections.getBoxedClassFor(value.getClass()))) {
            Object toCasted = value;
            return (To)toCasted;
        }
        Optional attempt1 = Reflections.getFactory(from, to).flatMap(factory -> Try.execute(() -> factory.apply(value)).filter(Objects::nonNull).toOptional());
        if (attempt1.isPresent()) {
            return (To)attempt1.get();
        }
        String stringValue = value.toString();
        Optional attempt2 = Reflections.getFactory(String.class, to).flatMap(factory -> Try.execute(() -> factory.apply(stringValue)).filter(Objects::nonNull).toOptional());
        return attempt2.orElse(null);
    }

    @Nonnull
    public static <From, To> Function<From, To> fromTo(@Nonnull Class<From> from, @Nonnull Class<To> to) {
        return value -> Conversions.fromTo(from, to, value);
    }

    @Generated
    private Conversions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

