/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.ExtendedIterable;
import de.scravy.bedrock.Functions;
import de.scravy.bedrock.Seq;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterators;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface Container<E>
extends ExtendedIterable<E> {
    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public boolean nonEmpty() {
        return !this.isEmpty();
    }

    @Nonnull
    default public String asString() {
        StringBuilder b = new StringBuilder();
        this.forEach(b::append);
        return b.toString();
    }

    @Nonnull
    default public String asString(@Nonnull String delimiter) {
        return this.stream().map(Objects::toString).collect(Collectors.joining(delimiter));
    }

    default public E draw(@Nonnull Random random) throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return Seq.ofCollectionInternal(this.toList()).draw(random);
    }

    default public E draw() throws NoSuchElementException {
        return this.draw(ThreadLocalRandom.current());
    }

    default public boolean forAll(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        for (Object e : this) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    default public boolean exists(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        for (Object e : this) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    default public boolean contains(E element) {
        return this.exists(Functions.predicate(Functions.curry(Objects::equals).apply(element)));
    }

    @Nonnull
    default public Stream<E> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 0), false);
    }

    @Nonnull
    default public List<E> toList() {
        ArrayList list = new ArrayList();
        for (Object e : this) {
            list.add(e);
        }
        return list;
    }

    public static <E> Container<E> fromIterable(Iterable<E> e) {
        return e::iterator;
    }
}

