/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Container;
import de.scravy.bedrock.EmptyIteratorException;
import de.scravy.bedrock.Unstable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import lombok.Generated;

@Unstable
public class Cons<E>
implements Container<E> {
    private static final Cons<?> EMPTY = new Empty();
    private final E head;
    private final Cons<E> tail;

    @Nonnull
    public static <E> Cons<E> empty() {
        return EMPTY;
    }

    @Nonnull
    public static <E> Cons<E> singleton(E value) {
        return new Cons<E>(value, Cons.empty());
    }

    @Nonnull
    public static <E> Cons<E> cons(E value, Cons<E> cons) {
        return new Cons<E>(value, cons);
    }

    public E head() {
        return this.head;
    }

    @Nonnull
    public Cons<E> tail() {
        return this.tail;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Nonnull
    public String toString() {
        return String.format("(%s,%s)", this.head(), this.tail());
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return new ConsIterator(this);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cons)) {
            return false;
        }
        Cons other = (Cons)o;
        if (!other.canEqual(this)) {
            return false;
        }
        E this$head = this.head;
        E other$head = other.head;
        if (this$head == null ? other$head != null : !this$head.equals(other$head)) {
            return false;
        }
        Cons<E> this$tail = this.tail;
        Cons<E> other$tail = other.tail;
        return !(this$tail == null ? other$tail != null : !((Object)this$tail).equals(other$tail));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cons;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        E $head = this.head;
        result = result * 59 + ($head == null ? 43 : $head.hashCode());
        Cons<E> $tail = this.tail;
        result = result * 59 + ($tail == null ? 43 : ((Object)$tail).hashCode());
        return result;
    }

    @Generated
    private Cons(E head, Cons<E> tail) {
        this.head = head;
        this.tail = tail;
    }

    private static final class ConsIterator<E>
    implements Iterator<E> {
        @Nonnull
        private Cons<E> current;

        @Override
        public boolean hasNext() {
            return this.current.nonEmpty();
        }

        @Override
        public E next() {
            if (this.current.isEmpty()) {
                throw new EmptyIteratorException();
            }
            E result = this.current.head();
            this.current = this.current.tail();
            return result;
        }

        @Generated
        public ConsIterator(@Nonnull Cons<E> current) {
            if (current == null) {
                throw new NullPointerException("current is marked non-null but is null");
            }
            this.current = current;
        }
    }

    private static class Empty<E>
    extends Cons<E> {
        private Empty() {
            super(null, null);
        }

        @Override
        public E head() {
            throw new NoSuchElementException();
        }

        @Override
        @Nonnull
        public Cons<E> tail() {
            throw new NoSuchElementException("invoked tail() on en empty() cons");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean nonEmpty() {
            return false;
        }

        @Override
        public boolean equals(Object e) {
            return e instanceof Empty;
        }

        @Override
        @Nonnull
        public String toString() {
            return "(<empty>)";
        }
    }
}

