/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.ExtendedIterable;
import de.scravy.bedrock.Function0;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.Generated;

public abstract class Box<T>
implements Function0<T>,
Consumer<T>,
ExtendedIterable<T> {
    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return Collections.singleton(this.get()).iterator();
    }

    public T apply(@Nonnull Function<T, T> function) {
        Objects.requireNonNull(function, "'function' must not be null.");
        this.accept(function.apply(this.get()));
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T applyAtomic(@Nonnull Function<T, T> function) {
        Box box = this;
        synchronized (box) {
            return this.apply(function);
        }
    }

    public boolean exists(@Nonnull Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null.");
        return predicate.test(this.get());
    }

    public boolean contains(T value) {
        if (value == null) {
            return this.get() == null;
        }
        return value.equals(this.get());
    }

    @Nonnull
    public static <T> Box<T> box(T value) {
        return new AnyBox(value);
    }

    @Nonnull
    public static <T> Box<T> box() {
        return new AnyBox(null);
    }

    @Nonnull
    public static IntBox intBox(int value) {
        return new IntBox(value);
    }

    @Nonnull
    public static LongBox longBox(long value) {
        return new LongBox(value);
    }

    @Nonnull
    public static DoubleBox doubleBox(double value) {
        return new DoubleBox(value);
    }

    @Nonnull
    public static IntBox intBox() {
        return new IntBox(0);
    }

    @Nonnull
    public static LongBox longBox() {
        return new LongBox(0L);
    }

    @Nonnull
    public static DoubleBox doubleBox() {
        return new DoubleBox(0.0);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Box)) {
            return false;
        }
        Box other = (Box)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Box;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "Box()";
    }

    @Generated
    private Box() {
    }

    private static class AnyBox<T>
    extends Box<T> {
        private T value;

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void accept(T value) {
            this.setValue(value);
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnyBox)) {
                return false;
            }
            AnyBox other = (AnyBox)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$value = this.getValue();
            T other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AnyBox;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public T getValue() {
            return this.value;
        }

        @Generated
        public void setValue(T value) {
            this.value = value;
        }

        @Override
        @Generated
        public String toString() {
            return "Box.AnyBox(value=" + this.getValue() + ")";
        }

        @Generated
        private AnyBox(T value) {
            this.value = value;
        }
    }

    public static class IntBox
    extends Box<Integer>
    implements NumberBox {
        private int intValue;

        @Override
        @Nonnull
        public Integer get() {
            return this.intValue;
        }

        @Override
        public void accept(@Nonnull Integer value) {
            this.intValue = value;
        }

        public int update(@Nonnull IntUnaryOperator function) {
            this.intValue = function.applyAsInt(this.intValue);
            return this.intValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int updateAtomic(@Nonnull IntUnaryOperator function) {
            IntBox intBox = this;
            synchronized (intBox) {
                this.intValue = function.applyAsInt(this.intValue);
            }
            return this.intValue;
        }

        @Override
        public void inc() {
            ++this.intValue;
        }

        @Override
        public void dec() {
            --this.intValue;
        }

        public void add(int value) {
            this.intValue += value;
        }

        public void sub(int value) {
            this.intValue -= value;
        }

        @Deprecated
        public boolean exists(IntPredicate predicate) {
            return this.intExists(predicate);
        }

        public boolean intExists(IntPredicate predicate) {
            return predicate.test(this.intValue);
        }

        public void setValue(int value) {
            this.intValue = value;
        }

        public int getValue() {
            return this.intValue;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntBox)) {
                return false;
            }
            IntBox other = (IntBox)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.intValue == other.intValue;
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IntBox;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.intValue;
            return result;
        }

        @Generated
        private IntBox(int intValue) {
            this.intValue = intValue;
        }
    }

    public static class LongBox
    extends Box<Long>
    implements NumberBox {
        private long longValue;

        @Override
        @Nonnull
        public Long get() {
            return this.longValue;
        }

        @Override
        public void accept(@Nonnull Long value) {
            this.longValue = value;
        }

        public long update(@Nonnull LongUnaryOperator function) {
            this.longValue = function.applyAsLong(this.longValue);
            return this.longValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long updateAtomic(@Nonnull LongUnaryOperator function) {
            LongBox longBox = this;
            synchronized (longBox) {
                this.longValue = function.applyAsLong(this.longValue);
            }
            return this.longValue;
        }

        @Override
        public void inc() {
            ++this.longValue;
        }

        @Override
        public void dec() {
            --this.longValue;
        }

        public void add(int value) {
            this.longValue += (long)value;
        }

        public void sub(int value) {
            this.longValue -= (long)value;
        }

        public void add(long value) {
            this.longValue += value;
        }

        public void sub(long value) {
            this.longValue -= value;
        }

        @Deprecated
        public boolean exists(LongPredicate predicate) {
            return this.longExists(predicate);
        }

        public boolean longExists(LongPredicate predicate) {
            return predicate.test(this.longValue);
        }

        public void setValue(long value) {
            this.longValue = value;
        }

        public long getValue() {
            return this.longValue;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LongBox)) {
                return false;
            }
            LongBox other = (LongBox)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.longValue == other.longValue;
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LongBox;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $longValue = this.longValue;
            result = result * 59 + (int)($longValue >>> 32 ^ $longValue);
            return result;
        }

        @Generated
        private LongBox(long longValue) {
            this.longValue = longValue;
        }
    }

    public static class DoubleBox
    extends Box<Double>
    implements NumberBox {
        private double doubleValue;

        @Override
        @Nonnull
        public Double get() {
            return this.doubleValue;
        }

        @Override
        public void accept(@Nonnull Double value) {
            this.doubleValue = value;
        }

        public double update(@Nonnull DoubleUnaryOperator function) {
            this.doubleValue = function.applyAsDouble(this.doubleValue);
            return this.doubleValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double updateAtomic(@Nonnull DoubleUnaryOperator function) {
            DoubleBox doubleBox = this;
            synchronized (doubleBox) {
                this.doubleValue = function.applyAsDouble(this.doubleValue);
            }
            return this.doubleValue;
        }

        @Override
        public void inc() {
            this.doubleValue += 1.0;
        }

        @Override
        public void dec() {
            this.doubleValue -= 1.0;
        }

        public void add(double value) {
            this.doubleValue += value;
        }

        public void sub(double value) {
            this.doubleValue -= value;
        }

        @Deprecated
        public boolean exists(DoublePredicate predicate) {
            return this.doubleExists(predicate);
        }

        public boolean doubleExists(DoublePredicate predicate) {
            return predicate.test(this.doubleValue);
        }

        public void setValue(double value) {
            this.doubleValue = value;
        }

        public double getValue() {
            return this.doubleValue;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DoubleBox)) {
                return false;
            }
            DoubleBox other = (DoubleBox)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Double.compare(this.doubleValue, other.doubleValue) == 0;
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DoubleBox;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $doubleValue = Double.doubleToLongBits(this.doubleValue);
            result = result * 59 + (int)($doubleValue >>> 32 ^ $doubleValue);
            return result;
        }

        @Generated
        private DoubleBox(double doubleValue) {
            this.doubleValue = doubleValue;
        }
    }

    static interface NumberBox {
        public void inc();

        public void dec();
    }
}

