/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.AbstractBuilder;
import de.scravy.bedrock.ArrayMap;
import de.scravy.bedrock.Pair;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public final class ArrayMapBuilder<K extends Comparable<? super K>, V>
extends AbstractBuilder<Pair<K, V>, ArrayMap<K, V>, ArrayMapBuilder<K, V>> {
    private final TreeMap<K, V> underlyingMap = new TreeMap();

    @Nonnull
    public ArrayMapBuilder<K, V> add(K key, V value) {
        this.underlyingMap.put(key, value);
        return this;
    }

    public ArrayMapBuilder<K, V> addKeyValue(K key, V value) {
        return this.add(key, value);
    }

    public ArrayMapBuilder<K, V> addPair(Pair<K, V> elem) {
        return this.add(elem);
    }

    @Override
    public ArrayMapBuilder<K, V> add(Pair<K, V> elem) {
        return this.add((Comparable)elem.fst(), elem.snd());
    }

    @Override
    @Nonnull
    public ArrayMap<K, V> result() {
        if (this.underlyingMap.isEmpty()) {
            return ArrayMap.empty();
        }
        return ArrayMap.ofMap(this.underlyingMap);
    }

    public ArrayMapBuilder<K, V> clear() {
        this.underlyingMap.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.underlyingMap.isEmpty();
    }

    public void forEach(BiConsumer<K, V> consumer) {
        this.forEach((? super T pair) -> consumer.accept((Comparable)pair.fst(), pair.snd()));
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        return new Iterator<Pair<K, V>>(){
            private final Iterator<Map.Entry<K, V>> underlyingIterator;
            {
                this.underlyingIterator = ArrayMapBuilder.this.underlyingMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.underlyingIterator.hasNext();
            }

            @Override
            public Pair<K, V> next() {
                Map.Entry entry = this.underlyingIterator.next();
                return Pair.of((Comparable)entry.getKey(), entry.getValue());
            }
        };
    }
}

