/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Builder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractBuilder<Element, TargetCollection, This extends AbstractBuilder<Element, TargetCollection, This>>
implements Builder<Element, TargetCollection> {
    public abstract This add(Element var1);

    @SafeVarargs
    @Nonnull
    public final This addAll(Element ... elems) {
        Objects.requireNonNull(elems);
        for (Element elem : elems) {
            this.add((Object)elem);
        }
        return (This)this;
    }

    @Nonnull
    public This addElements(Iterable<? extends Element> elems) {
        Objects.requireNonNull(elems);
        elems.forEach(object -> this.add(object));
        return (This)this;
    }

    @Nonnull
    public This addFromIterator(Iterator<? extends Element> it) {
        Objects.requireNonNull(it);
        it.forEachRemaining(object -> this.add(object));
        return (This)this;
    }

    @Nonnull
    public This addFromEnumeration(Enumeration<? extends Element> enumeration) {
        Objects.requireNonNull(enumeration);
        while (enumeration.hasMoreElements()) {
            this.add((Object)enumeration.nextElement());
        }
        return (This)this;
    }
}

