/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.extension.pace;

import de.schlichtherle.truezip.extension.pace.PaceManager;
import de.schlichtherle.truezip.extension.pace.PaceManagerController;
import de.schlichtherle.truezip.extension.pace.PaceManagerModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.util.BitField;
import java.util.Iterator;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.StandardMBean;

@ThreadSafe
final class PaceManagerView
extends StandardMBean
implements PaceManager {
    private final PaceManagerModel model;
    private volatile PaceManagerController controller;

    PaceManagerView(PaceManagerModel model) {
        super(PaceManager.class, true);
        this.model = model;
    }

    FsManager decorate(FsManager manager) {
        assert (!(manager instanceof PaceManagerController));
        PaceManagerController o = this.controller;
        PaceManagerModel m = null == o ? this.model : new PaceManagerModel();
        PaceManagerController n = new PaceManagerController(m, manager);
        if (null == o) {
            this.controller = n;
        }
        return n;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "A pace manager";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String name = info.getName();
        if (name.equals("FileSystemsMounted")) {
            return "The number of mounted file systems.";
        }
        if (name.equals("FileSystemsTotal")) {
            return "The total number of file systems.";
        }
        if (name.equals("MaximumFileSystemsMounted")) {
            return "The maximum number of mounted file systems.";
        }
        if (name.equals("TopLevelArchiveFileSystemsMounted")) {
            return "The number of mounted top level archive file systems.";
        }
        if (name.equals("TopLevelArchiveFileSystemsTotal")) {
            return "The total number of top level archive file systems.";
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        if (info.getName().equals("sync")) {
            return "Synchronizes all file systems.";
        }
        return null;
    }

    @Override
    public void sync() throws FsSyncException {
        if (null != this.controller) {
            this.controller.sync((BitField<FsSyncOption>)FsSyncOptions.NONE);
        }
    }

    @Override
    public int getFileSystemsTotal() {
        return null == this.controller ? 0 : this.controller.getSize();
    }

    @Override
    public int getFileSystemsMounted() {
        return this.model.getFileSystemsMounted();
    }

    @Override
    public int getMaximumFileSystemsMounted() {
        return this.model.getMaximumFileSystemsMounted();
    }

    @Override
    public void setMaximumFileSystemsMounted(int value) {
        this.model.setMaximumFileSystemsMounted(value);
    }

    @Override
    public int getTopLevelArchiveFileSystemsTotal() {
        int total = 0;
        if (null != this.controller) {
            Iterator i$ = this.controller.iterator();
            while (i$.hasNext()) {
                FsController c = (FsController)i$.next();
                if (!this.isTopLevelArchive(c)) continue;
                ++total;
            }
        }
        return total;
    }

    @Override
    public int getTopLevelArchiveFileSystemsMounted() {
        int mounted = 0;
        if (null != this.controller) {
            Iterator i$ = this.controller.iterator();
            while (i$.hasNext()) {
                FsController c = (FsController)i$.next();
                if (!this.isTopLevelArchive(c) || !c.getModel().isMounted()) continue;
                ++mounted;
            }
        }
        return mounted;
    }

    private boolean isTopLevelArchive(FsController<?> c) {
        FsController parent = c.getParent();
        return null != parent && null == parent.getParent();
    }
}

