/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.extension.pace;

import de.schlichtherle.truezip.extension.pace.PaceManager;
import de.schlichtherle.truezip.extension.pace.PaceManagerController;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsFilteringManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsResourceOpenException;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.HashMaps;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class PaceManagerModel {
    private static final Logger logger = Logger.getLogger(PaceManagerModel.class.getName(), PaceManagerModel.class.getName());
    private final Collection<FsController<? extends FsModel>> evicted = new ConcurrentLinkedQueue<FsController<? extends FsModel>>();
    private final MountedControllerSet mounted = new MountedControllerSet();
    private volatile int maxMounted = PaceManager.MAXIMUM_FILE_SYSTEMS_MOUNTED_DEFAULT_VALUE;
    @Nullable
    private volatile FsManager manager;

    PaceManagerModel() {
    }

    void init(FsManager manager) {
        assert (!(manager instanceof PaceManagerController));
        if (null != this.manager) {
            throw new IllegalStateException();
        }
        this.manager = manager;
        this.mounted.sync();
    }

    int getFileSystemsMounted() {
        return this.mounted.sync();
    }

    int getMaximumFileSystemsMounted() {
        return this.maxMounted;
    }

    void setMaximumFileSystemsMounted(int maxMounted) {
        if (maxMounted < 2) {
            throw new IllegalArgumentException();
        }
        this.maxMounted = maxMounted;
    }

    void retain(FsController<? extends FsModel> controller) throws FsSyncException {
        FsMountPoint mp = controller.getModel().getMountPoint();
        Iterator<FsController<? extends FsModel>> i = this.evicted.iterator();
        block2: while (i.hasNext()) {
            FsController<? extends FsModel> ec = i.next();
            FsMountPoint emp = ec.getModel().getMountPoint();
            FsFilteringManager fm = new FsFilteringManager(this.manager, emp);
            for (FsController fc : fm) {
                FsMountPoint fmp = fc.getModel().getMountPoint();
                if (!mp.equals((Object)fmp) && !this.mounted.contains(fmp)) continue;
                if (!emp.equals((Object)fmp) && !this.mounted.contains(emp)) continue block2;
                i.remove();
                continue block2;
            }
            try {
                fm.sync(FsSyncOptions.NONE);
                i.remove();
            }
            catch (FsSyncException ex) {
                if (ex.getCause() instanceof FsResourceOpenException) {
                    logger.log(Level.FINER, "ignoring", ex);
                    continue;
                }
                i.remove();
                throw ex;
            }
        }
    }

    void accessed(FsController<? extends FsModel> controller) {
        if (controller.getModel().isMounted()) {
            this.mounted.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sync(BitField<FsSyncOption> options) throws FsSyncException {
        this.evicted.clear();
        try {
            this.manager.sync(options);
        }
        finally {
            this.mounted.sync();
        }
    }

    private final class MountedControllerSet {
        private final LinkedHashMap<FsMountPoint, FsController<? extends FsModel>> map;
        private final ReentrantReadWriteLock.ReadLock readLock;
        private final ReentrantReadWriteLock.WriteLock writeLock;

        MountedControllerSet() {
            this.map = new LinkedHashMap<FsMountPoint, FsController<? extends FsModel>>(HashMaps.initialCapacity((int)(PaceManagerModel.this.getMaximumFileSystemsMounted() + 1)), 0.75f, true){

                @Override
                public boolean removeEldestEntry(Map.Entry<FsMountPoint, FsController<? extends FsModel>> entry) {
                    boolean evict;
                    boolean bl = evict = this.size() > PaceManagerModel.this.getMaximumFileSystemsMounted();
                    if (evict) {
                        FsController<? extends FsModel> c = entry.getValue();
                        boolean added = PaceManagerModel.this.evicted.add(c);
                        assert (added);
                    }
                    return evict;
                }
            };
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.readLock = lock.readLock();
            this.writeLock = lock.writeLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean contains(FsMountPoint key) {
            this.readLock.lock();
            try {
                boolean bl = this.map.containsKey(key);
                return bl;
            }
            finally {
                this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(FsController<? extends FsModel> controller) {
            FsMountPoint mp = controller.getModel().getMountPoint();
            this.writeLock.lock();
            try {
                this.map.put(mp, controller);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int sync() {
            if (null == PaceManagerModel.this.manager) {
                return this.map.size();
            }
            this.writeLock.lock();
            try {
                this.map.clear();
                for (FsController c : PaceManagerModel.this.manager) {
                    if (!c.getModel().isMounted()) continue;
                    this.map.put(c.getModel().getMountPoint(), (FsController<? extends FsModel>)c);
                }
                int n = this.map.size();
                return n;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }
}

