/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.extension.pace;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.extension.pace.PaceManagerController;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
final class PaceController
extends FsDecoratingController<FsModel, FsController<? extends FsModel>> {
    private final PaceManagerController manager;

    PaceController(PaceManagerController manager, FsController<?> controller) {
        super(controller);
        assert (null != manager);
        assert (null != controller.getParent());
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly() throws IOException {
        FsController c = this.delegate;
        this.manager.retain((FsController<? extends FsModel>)c);
        try {
            boolean bl = c.isReadOnly();
            return bl;
        }
        finally {
            this.manager.accessed((FsController<? extends FsModel>)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FsEntry getEntry(FsEntryName name) throws IOException {
        FsController c = this.delegate;
        this.manager.retain((FsController<? extends FsModel>)c);
        try {
            FsEntry fsEntry = c.getEntry(name);
            return fsEntry;
        }
        finally {
            this.manager.accessed((FsController<? extends FsModel>)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadable(FsEntryName name) throws IOException {
        FsController c = this.delegate;
        this.manager.retain((FsController<? extends FsModel>)c);
        try {
            boolean bl = c.isReadable(name);
            return bl;
        }
        finally {
            this.manager.accessed((FsController<? extends FsModel>)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWritable(FsEntryName name) throws IOException {
        FsController c = this.delegate;
        this.manager.retain((FsController<? extends FsModel>)c);
        try {
            boolean bl = c.isWritable(name);
            return bl;
        }
        finally {
            this.manager.accessed((FsController<? extends FsModel>)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExecutable(FsEntryName name) throws IOException {
        FsController c = this.delegate;
        this.manager.retain((FsController<? extends FsModel>)c);
        try {
            boolean bl = c.isExecutable(name);
            return bl;
        }
        finally {
            this.manager.accessed((FsController<? extends FsModel>)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnly(FsEntryName name) throws IOException {
        FsController c = this.delegate;
        this.manager.retain((FsController<? extends FsModel>)c);
        try {
            c.setReadOnly(name);
        }
        finally {
            this.manager.accessed((FsController<? extends FsModel>)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        FsController c = this.delegate;
        this.manager.retain((FsController<? extends FsModel>)c);
        try {
            boolean bl = c.setTime(name, times, options);
            return bl;
        }
        finally {
            this.manager.accessed((FsController<? extends FsModel>)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        FsController c = this.delegate;
        this.manager.retain((FsController<? extends FsModel>)c);
        try {
            boolean bl = c.setTime(name, types, value, options);
            return bl;
        }
        finally {
            this.manager.accessed((FsController<? extends FsModel>)c);
        }
    }

    public InputSocket<?> getInputSocket(final FsEntryName name, final BitField<FsInputOption> options) {
        @NotThreadSafe
        final class Input
        extends DecoratingInputSocket<Entry> {
            Input() {
                super(PaceController.this.delegate.getInputSocket(fsEntryName, bitField));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Entry getLocalTarget() throws IOException {
                FsController c = PaceController.this.delegate;
                PaceController.this.manager.retain((FsController<? extends FsModel>)c);
                try {
                    Entry entry = (Entry)this.getBoundSocket().getLocalTarget();
                    return entry;
                }
                finally {
                    PaceController.this.manager.accessed((FsController<? extends FsModel>)c);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                FsController c = PaceController.this.delegate;
                PaceController.this.manager.retain((FsController<? extends FsModel>)c);
                try {
                    ReadOnlyFile readOnlyFile = this.getBoundSocket().newReadOnlyFile();
                    return readOnlyFile;
                }
                finally {
                    PaceController.this.manager.accessed((FsController<? extends FsModel>)c);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                FsController c = PaceController.this.delegate;
                PaceController.this.manager.retain((FsController<? extends FsModel>)c);
                try {
                    SeekableByteChannel seekableByteChannel = this.getBoundSocket().newSeekableByteChannel();
                    return seekableByteChannel;
                }
                finally {
                    PaceController.this.manager.accessed((FsController<? extends FsModel>)c);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public InputStream newInputStream() throws IOException {
                FsController c = PaceController.this.delegate;
                PaceController.this.manager.retain((FsController<? extends FsModel>)c);
                try {
                    InputStream inputStream = this.getBoundSocket().newInputStream();
                    return inputStream;
                }
                finally {
                    PaceController.this.manager.accessed((FsController<? extends FsModel>)c);
                }
            }
        }
        return new Input();
    }

    public OutputSocket<?> getOutputSocket(final FsEntryName name, final BitField<FsOutputOption> options, final Entry template) {
        @NotThreadSafe
        final class Output
        extends DecoratingOutputSocket<Entry> {
            Output() {
                super(PaceController.this.delegate.getOutputSocket(fsEntryName, bitField, entry));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Entry getLocalTarget() throws IOException {
                FsController c = PaceController.this.delegate;
                PaceController.this.manager.retain((FsController<? extends FsModel>)c);
                try {
                    Entry entry = (Entry)this.getBoundSocket().getLocalTarget();
                    return entry;
                }
                finally {
                    PaceController.this.manager.accessed((FsController<? extends FsModel>)c);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                FsController c = PaceController.this.delegate;
                PaceController.this.manager.retain((FsController<? extends FsModel>)c);
                try {
                    SeekableByteChannel seekableByteChannel = this.getBoundSocket().newSeekableByteChannel();
                    return seekableByteChannel;
                }
                finally {
                    PaceController.this.manager.accessed((FsController<? extends FsModel>)c);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public OutputStream newOutputStream() throws IOException {
                FsController c = PaceController.this.delegate;
                PaceController.this.manager.retain((FsController<? extends FsModel>)c);
                try {
                    OutputStream outputStream = this.getBoundSocket().newOutputStream();
                    return outputStream;
                }
                finally {
                    PaceController.this.manager.accessed((FsController<? extends FsModel>)c);
                }
            }
        }
        return new Output();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, Entry template) throws IOException {
        FsController c = this.delegate;
        this.manager.retain((FsController<? extends FsModel>)c);
        try {
            c.mknod(name, type, options, template);
        }
        finally {
            this.manager.accessed((FsController<? extends FsModel>)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        FsController c = this.delegate;
        this.manager.retain((FsController<? extends FsModel>)c);
        try {
            c.unlink(name, options);
        }
        finally {
            this.manager.accessed((FsController<? extends FsModel>)c);
        }
    }
}

