/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.fs.inst.jmx.JmxIOStatistics;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class JmxSeekableByteChannel
extends DecoratingSeekableByteChannel {
    private final JmxIOStatistics stats;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    JmxSeekableByteChannel(@WillCloseWhenClosed SeekableByteChannel sbc, JmxIOStatistics stats) {
        super(sbc);
        assert (null != stats);
        this.stats = stats;
    }

    public int read(ByteBuffer buf) throws IOException {
        int ret = this.delegate.read(buf);
        if (0 < ret) {
            this.stats.incBytesRead(ret);
        }
        return ret;
    }

    public int write(ByteBuffer buf) throws IOException {
        int ret = this.delegate.write(buf);
        this.stats.incBytesWritten(ret);
        return ret;
    }
}

